/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractViewConstants
extends AbstractConstantAction {
    private Map fields;
    protected String up;
    protected String down;
    protected String name;
    protected String description;
    protected String iconurl;
    protected String make;
    private final TranslationManager translationManager;

    protected AbstractViewConstants(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public String doAddConstant() throws Exception {
        this.validateName();
        if (this.invalidInput()) {
            return "error";
        }
        this.addConstant();
        return this.redirectToView();
    }

    protected void validateName() {
        if (StringUtils.isBlank((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.a.name.for.the.to.be.added", this.getNiceConstantName()));
        } else {
            for (GenericValue constantGv : this.getConstants()) {
                if (!this.name.trim().equalsIgnoreCase(constantGv.getString("name"))) continue;
                this.addError("name", this.getText("admin.errors.constant.already.exists", this.getNiceConstantName()));
                break;
            }
        }
    }

    protected abstract GenericValue addConstant() throws GenericEntityException;

    protected abstract String redirectToView();

    protected void addField(String key, Object value) {
        if (this.getFields() == null) {
            this.fields = new HashMap();
        }
        this.getFields().put(key, value);
    }

    private Map getFields() {
        return this.fields;
    }

    public boolean isDefault(GenericValue constant) {
        String constantId = this.getApplicationProperties().getString(this.getDefaultPropertyName());
        return constantId != null && constant.getString("id").equals(constantId);
    }

    protected abstract String getDefaultPropertyName();

    public void setUp(String up) {
        this.up = up;
    }

    public void setDown(String down) {
        this.down = down;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

