/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.upgrade.UpgradeLauncher;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.scheduler.SchedulerUtil;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;

public class JiraSystemRestarterImpl
implements JiraSystemRestarter {
    private static final Logger log = Logger.getLogger(JiraSystemRestarterImpl.class);
    private static final String JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED = "JIRA is about to be internally restarted";
    private static final String JIRA_HAS_BEEN_INTERNALLY_RESTARTED = "JIRA has been internally restarted";

    @Override
    public void ariseSirJIRA() {
        log.info((Object)JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED);
        this.stopServicesInOtherThread();
        this.restartPico();
        this.startServicesInOtherThreads();
        this.quiescePassiveNode();
        log.info((Object)JIRA_HAS_BEEN_INTERNALLY_RESTARTED);
    }

    @Override
    public void ariseSirJIRAandUpgradeThySelf(ServletContext servletContext) {
        log.info((Object)JIRA_IS_ABOUT_TO_BE_INTERNALLY_RESTARTED);
        this.stopServicesInOtherThread();
        this.restartPico();
        UpgradeLauncher.checkIfUpgradeNeeded(servletContext);
        this.startServicesInOtherThreads();
        this.quiescePassiveNode();
        log.info((Object)JIRA_HAS_BEEN_INTERNALLY_RESTARTED);
    }

    private void restartPico() {
        log.info((Object)"Restarting JIRA code components...");
        ManagerFactory.globalRefresh();
        log.info((Object)"JIRA code components started");
    }

    private void stopServicesInOtherThread() {
        log.info((Object)"Stopping the JIRA Scheduler...");
        SchedulerUtil schedUtil = new SchedulerUtil();
        Scheduler sched = ManagerFactory.getScheduler();
        schedUtil.shutdownScheduler(sched);
        log.info((Object)"JIRA Scheduler Stopped");
        log.info((Object)"Empting the JIRA Mail Queue...");
        try {
            ManagerFactory.getMailQueue().sendBuffer();
            log.info((Object)"JIRA Mail Queue emptied");
        }
        catch (Exception e) {
            log.warn((Object)("Failed to empty the Mail Queue: " + e.getMessage()), (Throwable)e);
        }
    }

    private void startServicesInOtherThreads() {
        log.info((Object)"Restarting the JIRA Scheduler...");
        SchedulerUtil schedUtil = new SchedulerUtil();
        Scheduler scheduler = ComponentAccessor.getScheduler();
        schedUtil.initialize(scheduler);
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isActive()) {
            schedUtil.start(scheduler);
        }
        log.info((Object)"JIRA Scheduler started");
    }

    private void quiescePassiveNode() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (!clusterManager.isActive()) {
            NodeStateManager nodeStateManager = (NodeStateManager)ComponentAccessor.getComponent(NodeStateManager.class);
            try {
                nodeStateManager.deactivate();
            }
            catch (NotClusteredException notClusteredException) {
                // empty catch block
            }
        }
    }
}

