/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.concurrent;

import com.atlassian.jira.util.RuntimeInterruptedException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class BoundedExecutor
implements Executor {
    private final ExecutorService executor;
    private final Lock lock;

    public BoundedExecutor(ExecutorService executor, int permits) {
        this.executor = executor;
        this.lock = new SemaphoreLock(permits);
    }

    @Override
    public void execute(final Runnable command) {
        this.lock.lock();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedExecutor.this.lock.unlock();
                    }
                }
            });
        }
        catch (RejectedExecutionException rej) {
            this.lock.unlock();
            throw rej;
        }
    }

    public <T> Future<T> submit(final Callable<T> task) {
        this.lock.lock();
        try {
            return this.executor.submit(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    try {
                        Object v = task.call();
                        return v;
                    }
                    finally {
                        BoundedExecutor.this.lock.unlock();
                    }
                }
            });
        }
        catch (RejectedExecutionException rej) {
            this.lock.unlock();
            throw rej;
        }
    }

    public void shutdownAndWait() {
        this.executor.shutdown();
        while (true) {
            try {
                while (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void shutdownAndIgnoreQueue() {
        this.executor.shutdownNow();
    }

    private final class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        public SemaphoreLock(int permits) {
            this.semaphore = new Semaphore(permits);
        }

        @Override
        public void lock() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }

        @Override
        public void unlock() {
            this.semaphore.release();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }
    }
}

