/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ExecutionException;

@EventComponent
public class DefaultUserPreferencesManager
implements UserPreferencesManager {
    private final Cache<String, JiraUserPreferences> cache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1000).build((CacheLoader)new CacheLoader<String, JiraUserPreferences>(){

        public JiraUserPreferences load(String userkey) {
            return new JiraUserPreferences(DefaultUserPreferencesManager.this.userManager.getUserByKey(userkey));
        }
    });
    private final UserManager userManager;
    private final UserPropertyManager userPropertyManager;

    public DefaultUserPreferencesManager(UserManager userManager, UserPropertyManager userPropertyManager) {
        this.userManager = userManager;
        this.userPropertyManager = userPropertyManager;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public ExtendedPreferences getExtendedPreferences(ApplicationUser user) {
        if (user == null) {
            return new JiraUserPreferences((ApplicationUser)null);
        }
        return (ExtendedPreferences)this.cache.getUnchecked((Object)user.getKey());
    }

    public Preferences getPreferences(ApplicationUser user) {
        return this.getExtendedPreferences(user);
    }

    public Preferences getPreferences(User user) {
        if (user == null) {
            return new JiraUserPreferences((User)null);
        }
        String userkey = ApplicationUsers.getKeyFor((User)user);
        try {
            return (Preferences)this.cache.get((Object)userkey);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    public void clearCache(ApplicationUser user) {
        if (user != null) {
            this.clearCacheByKey(user.getKey());
        }
    }

    public void clearCacheByKey(String userKey) {
        if (userKey != null) {
            this.cache.invalidate((Object)userKey);
            this.userPropertyManager.clearCacheByKey(userKey);
        }
    }
}

