/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.UserKeyService;
import java.util.Map;

public class UserDeleteVetoImpl
implements UserDeleteVeto {
    private final OfBizDelegator ofBizDelegator;
    private final UserKeyService userKeyService;

    public UserDeleteVetoImpl(OfBizDelegator ofBizDelegator, UserKeyService userKeyService) {
        this.ofBizDelegator = ofBizDelegator;
        this.userKeyService = userKeyService;
    }

    @Override
    public boolean allowDeleteUser(User user) {
        String userKey = this.userKeyService.getKeyForUser(user);
        long count = this.ofBizDelegator.getCountByAnd("Issue", (Map)new FieldMap("assignee", (Object)userKey));
        if (count > 0L) {
            return false;
        }
        count = this.ofBizDelegator.getCountByAnd("Issue", (Map)new FieldMap("reporter", (Object)userKey));
        if (count > 0L) {
            return false;
        }
        return this.getCommentCountByAuthor(userKey) <= 0L;
    }

    @Override
    public long getCommentCountByAuthor(ApplicationUser user) {
        return this.getCommentCountByAuthor(user.getKey());
    }

    private long getCommentCountByAuthor(String userKey) {
        return this.ofBizDelegator.getCountByAnd("Action", (Map)new FieldMap("author", (Object)userKey));
    }
}

