/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class DefaultUserIssueHistoryManager
implements UserIssueHistoryManager {
    private static final Logger log = Logger.getLogger(DefaultUserIssueHistoryManager.class);
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final UserHistoryManager userHistoryManager;
    private final ApplicationProperties applicationProperties;

    public DefaultUserIssueHistoryManager(UserHistoryManager userHistoryManager, PermissionManager permissionManager, IssueManager issueManager, ApplicationProperties applicationProperties) {
        this.userHistoryManager = userHistoryManager;
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
    }

    public void addIssueToHistory(@Nonnull User user, @Nonnull Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUE, user, issue.getId().toString());
    }

    public boolean hasIssueHistory(User user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.ISSUE, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(historyItem.getEntityId()));
                if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public List<UserHistoryItem> getFullIssueHistoryWithoutPermissionChecks(User user) {
        return this.userHistoryManager.getHistory(UserHistoryItem.ISSUE, user);
    }

    public List<UserHistoryItem> getFullIssueHistoryWithPermissionChecks(User user) {
        return this.getViewableIssueHistory(user, null);
    }

    @Nonnull
    public List<Issue> getShortIssueHistory(User user) {
        int maxItems = 6;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.history.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.history.dropdown.items'.  Should be a number.");
        }
        return this.getViewableIssuesFromHistory(user, maxItems);
    }

    private List<Issue> getViewableIssuesFromHistory(User user, Integer maxItems) {
        List<UserHistoryItem> history = this.getFullIssueHistoryWithoutPermissionChecks(user);
        ArrayList<Issue> returnList = new ArrayList<Issue>();
        if (history != null) {
            for (UserHistoryItem userHistoryItem : history) {
                MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(userHistoryItem.getEntityId()));
                if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
                returnList.add((Issue)issue);
                if (maxItems == null || returnList.size() < maxItems) continue;
                return returnList;
            }
        }
        return returnList;
    }

    private List<UserHistoryItem> getViewableIssueHistory(User user, Integer maxItems) {
        List<UserHistoryItem> history = this.getFullIssueHistoryWithoutPermissionChecks(user);
        ArrayList<UserHistoryItem> returnList = new ArrayList<UserHistoryItem>();
        if (history != null) {
            for (UserHistoryItem userHistoryItem : history) {
                MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(userHistoryItem.getEntityId()));
                if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) continue;
                returnList.add(userHistoryItem);
                if (maxItems == null || returnList.size() < maxItems) continue;
                return returnList;
            }
        }
        return returnList;
    }
}

