/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserKeyStoreImpl;
import com.atlassian.jira.util.Visitor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6137
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6137.class);
    final Set<String> unmappedKeys = new HashSet<String>();
    final Set<String> mappedKeys = new HashSet<String>();
    final Set<String> mappedNames = new HashSet<String>();
    final UnmappedKeyCollector unmappedKeyCollector = new UnmappedKeyCollector();
    private final EntityEngine entityEngine;
    private final UserKeyStoreImpl userKeyStore;
    private final boolean debug;

    public UpgradeTask_Build6137(EntityEngine entityEngine, UserKeyStore userKeyStore) {
        super(false);
        this.entityEngine = entityEngine;
        this.userKeyStore = (UserKeyStoreImpl)userKeyStore;
        this.debug = log.isDebugEnabled();
    }

    @Override
    public String getBuildNumber() {
        return "6137";
    }

    @Override
    public String getShortDescription() {
        return "Ensure that every assignee and reporter has a userkey mapping";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.findUnmappedUserKeys();
        this.mappedKeys.clear();
        log.info((Object)("Found " + this.unmappedKeys.size() + " unmapped user" + (this.unmappedKeys.size() == 1 ? "" : "s")));
        if (this.unmappedKeys.isEmpty()) {
            return;
        }
        for (String userKey : this.unmappedKeys) {
            String lowerUserName = this.findAvailableUserName(userKey);
            if (this.debug) {
                log.debug((Object)("Creating mapping for deleted user: userKey=[" + userKey + "] -> lowerUserName=[" + lowerUserName + ']'));
            }
            try {
                this.entityEngine.createValue(Entity.APPLICATION_USER, new ApplicationUserEntity(null, userKey, lowerUserName));
            }
            catch (DataAccessException dae) {
                log.error((Object)("Unable to creating mapping for deleted user: userKey=[" + userKey + "] -> lowerUserName=[" + lowerUserName + "]: " + (Object)((Object)dae)));
            }
        }
        this.userKeyStore.onClearCache(null);
    }

    private void findUnmappedUserKeys() {
        this.loadExistingApplicationUsers();
        this.findUnmappedKeysInField("Issue", "assignee");
        this.findUnmappedKeysInField("Issue", "reporter");
    }

    private String findAvailableUserName(String userKey) {
        if (this.mappedNames.add(userKey)) {
            return userKey;
        }
        int count = 1;
        String lowerUserKey = IdentifierUtils.toLowerCase((String)userKey);
        String lowerUserName = lowerUserKey + "#1";
        while (!this.mappedNames.add(lowerUserName)) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("Deleted user eviction namespace exhausted");
            }
            lowerUserName = lowerUserKey + '#' + ++count;
        }
        return lowerUserName;
    }

    private void loadExistingApplicationUsers() {
        Select.columns("userKey", "lowerUserName").from(Entity.APPLICATION_USER.getEntityName()).runWith(this.entityEngine).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue genericValue) {
                UpgradeTask_Build6137.this.mappedKeys.add(genericValue.getString("userKey"));
                UpgradeTask_Build6137.this.mappedNames.add(genericValue.getString("lowerUserName"));
            }
        });
    }

    private void findUnmappedKeysInField(String entityName, String fieldName) {
        Select.distinctString(fieldName).from(entityName).runWith(this.entityEngine).visitWith(this.unmappedKeyCollector);
    }

    class UnmappedKeyCollector
    implements Visitor<String> {
        UnmappedKeyCollector() {
        }

        public void visit(@Nullable String userKey) {
            if (userKey != null && userKey.length() > 0 && !UpgradeTask_Build6137.this.mappedKeys.contains(userKey)) {
                UpgradeTask_Build6137.this.unmappedKeys.add(userKey);
            }
        }
    }
}

