/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.log4j.Logger;

public class UpgradeTask_Build6135
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6135.class);
    private final ProjectManager projectManager;

    public UpgradeTask_Build6135(ProjectManager projectManager) {
        super(false);
        this.projectManager = projectManager;
    }

    @Override
    public String getBuildNumber() {
        return "6135";
    }

    @Override
    public String getShortDescription() {
        return "Filling in originalKey in project table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Connection connection = this.getDatabaseConnection();
        try {
            String updateSql = "UPDATE " + this.convertToSchemaTableName("project") + " SET originalkey = pkey WHERE originalkey IS NULL";
            PreparedStatement updateStmt = connection.prepareStatement(updateSql);
            try {
                int updatedCount = updateStmt.executeUpdate();
                log.info((Object)String.format("Updated %d projects.", updatedCount));
            }
            finally {
                updateStmt.close();
            }
        }
        finally {
            connection.close();
        }
        this.projectManager.refresh();
    }
}

