/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.FindMixedCaseUsernames;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;

public class UpgradeTask_Build6038
extends AbstractUpgradeTask {
    private final EntityEngine entityEngine;
    private boolean needReindex = false;

    public UpgradeTask_Build6038(EntityEngine entityEngine) {
        super(true);
        this.entityEngine = entityEngine;
    }

    @Override
    public boolean isReindexRequired() {
        return this.needReindex;
    }

    @Override
    public String getBuildNumber() {
        return "6038";
    }

    @Override
    public String getShortDescription() {
        return String.format("Convert author to lowercase in %s, and assignee/reporter values to lowercase in %s", "ChangeGroup", "ChangeItem");
    }

    @Override
    public void doUpgrade(boolean setupMode) throws SQLException {
        this.updateChangeGroupAuthors();
        this.updateChangeItemValues();
    }

    private void updateChangeGroupAuthors() throws SQLException {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("author").from("ChangeGroup");
        Map<String, String> userNamesToConvert = this.entityEngine.run(selectQuery).consumeWith(FindMixedCaseUsernames.fromStrings());
        if (userNamesToConvert.isEmpty()) {
            return;
        }
        this.needReindex = true;
        for (Map.Entry<String, String> entry : userNamesToConvert.entrySet()) {
            this.entityEngine.execute(Update.into("ChangeGroup").set("author", entry.getValue()).whereEqual("author", entry.getKey()));
        }
    }

    private void updateChangeItemValues() throws SQLException {
        this.forceChangeItemsToLower("assignee", "oldvalue");
        this.forceChangeItemsToLower("assignee", "newvalue");
        this.forceChangeItemsToLower("reporter", "oldvalue");
        this.forceChangeItemsToLower("reporter", "newvalue");
    }

    private void forceChangeItemsToLower(String issueFieldName, String changeItemFieldName) throws SQLException {
        if (this.isDatabasePickyAboutClobs()) {
            this.forceChangeItemsToLowerTheSlowWay(issueFieldName, changeItemFieldName);
            return;
        }
        Select.WhereContext<String> fieldQuery = Select.distinctString(changeItemFieldName).from("ChangeItem").whereEqual("field", issueFieldName);
        Map<String, String> usernameMap = this.entityEngine.run(fieldQuery).consumeWith(FindMixedCaseUsernames.fromStrings());
        if (usernameMap.isEmpty()) {
            return;
        }
        this.needReindex = true;
        for (Map.Entry<String, String> entry : usernameMap.entrySet()) {
            this.entityEngine.execute(Update.into("ChangeItem").set(changeItemFieldName, entry.getValue()).whereEqual("field", issueFieldName).andEqual(changeItemFieldName, entry.getKey()));
        }
    }

    private void forceChangeItemsToLowerTheSlowWay(String issueFieldName, String changeItemFieldName) {
        Select.WhereContext<GenericValue> fieldQuery = Select.columns("id", changeItemFieldName).from("ChangeItem").whereEqual("field", issueFieldName);
        Map<String, List<Long>> usernameMap = this.entityEngine.run(fieldQuery).consumeWith(FindMixedCaseUsernames.fromColumnAndReturnIds(changeItemFieldName));
        if (usernameMap.isEmpty()) {
            return;
        }
        this.needReindex = true;
        for (Map.Entry<String, List<Long>> entry : usernameMap.entrySet()) {
            String lowerUsername = entry.getKey();
            for (Long id : entry.getValue()) {
                this.entityEngine.execute(Update.into("ChangeItem").set(changeItemFieldName, lowerUsername).whereEqual("field", issueFieldName).andEqual("id", id));
            }
        }
    }

    boolean isDatabasePickyAboutClobs() throws SQLException {
        DatabaseType type = this.getDatabaseType();
        return this.isOracle(type) || this.isMsSql(type);
    }

    private boolean isOracle(DatabaseType databaseType) {
        return databaseType.getFieldTypeName().startsWith("oracle");
    }

    private boolean isMsSql(DatabaseType databaseType) {
        return databaseType.getFieldTypeName().startsWith("mssql");
    }
}

