/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bean.export.AutoExport;
import com.atlassian.jira.bean.export.AutoExportImpl;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.upgrade.BuildVersionRegistry;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeHistoryItemImpl;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.DowngradeUtilsImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeManagerImpl
implements UpgradeManager,
Startable {
    private static final Logger log = Logger.getLogger(UpgradeManagerImpl.class);
    private static final String UPGRADES_XML = "upgrades.xml";
    private static final Comparator<String> BUILD_NUMBER_COMPARATOR = new BuildNumComparator();
    private static final Pattern BUILD_NUMBER_PATTERN = Pattern.compile("\\d+$");
    private static final String ENTITY_UPGRADE_VERSION_HISTORY = "UpgradeVersionHistory";
    private static final String ENTITY_UPGRADE_HISTORY = "UpgradeHistory";
    private static final String FIELD_TARGETBUILD = "targetbuild";
    private static final String FIELD_TIMEPERFORMED = "timeperformed";
    private static final String FIELD_TARGETVERSION = "targetversion";
    private static final String FIELD_UPGRADECLASS = "upgradeclass";
    private final ApplicationProperties applicationProperties;
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper.BeanFactory i18HelperFactory;
    private final BuildVersionRegistry buildVersionRegistry;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final IndexLifecycleManager indexManager;
    private final OfBizDelegator ofBizDelegator;
    private final OutlookDateManager outlookDateManager;
    private final DowngradeUtilsImpl downgradeUtilsInfo;
    private SortedMap<String, UpgradeTask> allUpgrades;
    private SortedMap<String, UpgradeTask> setupUpgrades;
    private final String upgradeTaskFileName;
    private volatile Map<String, GenericValue> upgradeHistoryMap;
    private volatile String exportFilePath;

    public UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, FeatureManager featureManager, DowngradeUtilsImpl downgradeUtilsInfo) {
        this(jiraLicenseService, buildUtilsInfo, i18HelperFactory, applicationProperties, buildVersionRegistry, eventPublisher, ofBizDelegator, indexManager, outlookDateManager, UPGRADES_XML, featureManager, downgradeUtilsInfo);
    }

    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, String upgradeTaskFileName, FeatureManager featureManager, DowngradeUtilsImpl downgradeUtilsInfo) {
        this.eventPublisher = eventPublisher;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.i18HelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18HelperFactory", (Object)i18HelperFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildVersionRegistry = (BuildVersionRegistry)Assertions.notNull((String)"buildVersionRegistry", (Object)buildVersionRegistry);
        this.outlookDateManager = outlookDateManager;
        this.upgradeTaskFileName = upgradeTaskFileName;
        this.ofBizDelegator = ofBizDelegator;
        this.indexManager = indexManager;
        this.featureManager = featureManager;
        this.downgradeUtilsInfo = downgradeUtilsInfo;
    }

    @VisibleForTesting
    UpgradeManagerImpl(JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18HelperFactory, ApplicationProperties applicationProperties, BuildVersionRegistry buildVersionRegistry, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, IndexLifecycleManager indexManager, OutlookDateManager outlookDateManager, FeatureManager featureManager, Iterable<? extends UpgradeTask> upgradeTasks, Iterable<? extends UpgradeTask> setupUpgradeTasks, DowngradeUtilsImpl downgradeUtilsInfo) {
        this.eventPublisher = eventPublisher;
        this.indexManager = indexManager;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.i18HelperFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18HelperFactory", (Object)i18HelperFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildVersionRegistry = (BuildVersionRegistry)Assertions.notNull((String)"buildVersionRegistry", (Object)buildVersionRegistry);
        this.ofBizDelegator = ofBizDelegator;
        this.outlookDateManager = outlookDateManager;
        this.featureManager = featureManager;
        this.allUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
        this.setupUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"upgradeTasks", upgradeTasks)) {
            this.allUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
        }
        for (UpgradeTask upgradeTask : (Iterable)Assertions.notNull((String)"setupUpgradeTasks", setupUpgradeTasks)) {
            this.setupUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
        }
        this.upgradeTaskFileName = null;
        this.downgradeUtilsInfo = downgradeUtilsInfo;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.upgradeHistoryMap = null;
    }

    private SortedSet<String> getAllRelevantUpgradeBuildNumbers() {
        TreeSet<String> numbers = new TreeSet<String>(BUILD_NUMBER_COMPARATOR);
        SortedMap<String, UpgradeTask> standardupgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
        this.addUpgradeNumbersFromMap(numbers, standardupgrades);
        return numbers;
    }

    private SortedSet<String> getSetupUpgradeBuildNumbers() {
        TreeSet<String> numbers = new TreeSet<String>(BUILD_NUMBER_COMPARATOR);
        this.addUpgradeNumbersFromMap(numbers, this.setupUpgrades);
        return numbers;
    }

    private void addUpgradeNumbersFromMap(SortedSet<String> numbers, Map<String, UpgradeTask> upgradeMap) {
        for (String buildNumber : upgradeMap.keySet()) {
            numbers.add(buildNumber);
        }
    }

    private void addAllUpgradesInResourceFile(Map<String, UpgradeTask> upgradeSet, Map<String, UpgradeTask> setupSet, String fileName) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)fileName, this.getClass());
        try {
            Document doc = new Document(is);
            Element root = doc.getRoot();
            Elements actions = root.getElements("upgrade");
            while (actions.hasMoreElements()) {
                Element action = (Element)actions.nextElement();
                String className = action.getElement("class").getTextString();
                try {
                    UpgradeTask task = (UpgradeTask)JiraUtils.loadComponent(className, this.getClass());
                    if ("only".equals(action.getAttribute("setup"))) {
                        setupSet.put(action.getAttribute("build"), task);
                        continue;
                    }
                    upgradeSet.put(action.getAttribute("build"), task);
                    if (!"true".equals(action.getAttribute("setup"))) continue;
                    setupSet.put(action.getAttribute("build"), task);
                }
                catch (Exception e) {
                    log.error((Object)("Exception loading type: " + className), (Throwable)e);
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)"Exception: ", (Throwable)e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)("Could not close " + fileName + " inputStream"));
        }
    }

    private boolean needUpgrade() {
        return this.buildUtilsInfo.getApplicationBuildNumber() > this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    @Override
    public UpgradeManager.Status doUpgradeIfNeededAndAllowed(@Nullable String backupPath, boolean setupMode) throws IllegalXMLCharactersException {
        UpgradeManager.Status status;
        LicenseDetails licenseDetails = this.jiraLicenseService.getLicense();
        if (licenseDetails.isLicenseSet()) {
            if (!licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate()) && !licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone()) {
                String logMsg1 = "The current license is too old to run this version of JIRA " + this.buildUtilsInfo.getVersion() + " - " + this.buildUtilsInfo.getCurrentBuildDate();
                String logMsg2 = "The maintenance period of your license expired on " + licenseDetails.getMaintenanceEndString(this.outlookDateManager.getOutlookDate(Locale.ENGLISH));
                log.info((Object)logMsg1);
                log.info((Object)logMsg2);
                log.info((Object)"Cannot proceed with the upgrade.");
                return new UpgradeManager.Status(logMsg1 + "\n" + logMsg2);
            }
            JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(this.i18HelperFactory.getInstance(Locale.ENGLISH), licenseDetails.getLicenseString());
            if (validationResult.getErrorCollection().hasAnyErrors()) {
                log.info((Object)"The current license is not compatible with this installation of JIRA.");
                return this.createErrorMessages(validationResult);
            }
        }
        if ((status = this.doUpgradeIfNeeded(backupPath, setupMode)).succesful()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(false));
        }
        return status;
    }

    private UpgradeManager.Status createErrorMessages(JiraLicenseService.ValidationResult validationResult) {
        ArrayList<String> licenseErrors = new ArrayList<String>();
        ErrorCollection errorCollection = validationResult.getErrorCollection();
        for (String err : errorCollection.getErrorMessages()) {
            licenseErrors.add(String.valueOf(err));
        }
        Map errorMap = errorCollection.getErrors();
        for (Map.Entry entry : errorMap.entrySet()) {
            licenseErrors.add(entry.getKey() + " : " + entry.getValue());
        }
        return new UpgradeManager.Status(false, licenseErrors);
    }

    private UpgradeManager.Status doUpgradeIfNeeded(String defaultBackupPath, boolean setupMode) throws IllegalXMLCharactersException {
        if (this.needUpgrade()) {
            log.info((Object)("Detected that an upgrade is needed; existing data at build " + this.getJiraBuildNumber()));
            if ("true".equals(this.applicationProperties.getString("jira.setup"))) {
                if (!this.autoExportDisabled() && defaultBackupPath != null) {
                    log.info((Object)"Exporting the existing data..");
                    AutoExport ae = this.getAutoExport(defaultBackupPath);
                    try {
                        String exportFilePath = ae.exportData();
                        log.info((Object)("Exported pre-upgrade data to: " + exportFilePath));
                        this.setExportFilePath(exportFilePath);
                    }
                    catch (IllegalXMLCharactersException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error occurred during export before upgrade: " + e + ". If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport")), (Throwable)e);
                        ImmutableList errors = ImmutableList.of((Object)("Error occurred during export before upgrade: " + e.getMessage() + "\n If necessary, auto-export can be disabled; see " + ExternalLinkUtilImpl.getInstance().getProperty("external.link.jira.doc.disable.autoexport") + "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
                        return new UpgradeManager.Status(false, (Collection<String>)errors);
                    }
                }
            } else {
                log.debug((Object)"Not doing an auto-export.");
            }
            return this.doUpgrade(setupMode);
        }
        log.debug((Object)"Detected that no upgrade is neccessary");
        this.setVersions(this.buildUtilsInfo.getCurrentBuildNumber());
        return new UpgradeManager.Status(false, Collections.<String>emptyList());
    }

    protected AutoExport getAutoExport(String defaultBackupPath) {
        return new AutoExportImpl(defaultBackupPath);
    }

    private boolean autoExportDisabled() {
        return this.featureManager.isOnDemand() || !this.applicationProperties.getOption("jira.autoexport") || JiraSystemProperties.isDevMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeManager.Status doUpgrade(boolean setupMode) {
        UpgradeManager.Status status;
        log.info((Object)"___ Performing Upgrade ____________________");
        this.getUpgrades();
        try {
            SortedSet<String> upgradeNumbers = this.getAllRelevantUpgradeBuildNumbers();
            SortedMap<String, UpgradeTask> standardUpgrades = this.getRelevantUpgradesFromList(this.allUpgrades);
            status = this.runUpgradeTasks(upgradeNumbers, standardUpgrades, setupMode);
            if (status.succesful()) {
                this.logUpgradeSuccessfulMsg();
                this.setVersions(this.buildUtilsInfo.getCurrentBuildNumber());
            } else {
                log.error((Object)"Errors occurred during upgrade:");
                this.printErrors(status.getErrors());
            }
        }
        catch (Exception upgradeException) {
            status = this.handleError(upgradeException);
        }
        finally {
            this.releaseUpgrades();
            this.refreshSequencer();
        }
        return status;
    }

    private void printErrors(Collection<String> errors) {
        for (String s : errors) {
            log.error((Object)("Upgrade Error: " + s));
        }
    }

    private UpgradeManager.Status runUpgradeTasks(Collection<String> upgradeNumbers, Map<String, UpgradeTask> upgradeTasks, boolean setupMode) throws Exception {
        boolean doReindex;
        boolean reindexRequired = false;
        ArrayList<String> errors = new ArrayList<String>();
        Map<String, GenericValue> upgradeHistoryMap = this.getPreviouslyRunUpgrades();
        boolean noErrors = true;
        for (String number : upgradeNumbers) {
            UpgradeTask standardUpgradeTask = upgradeTasks.get(number);
            if (!this.doUpgradeTaskSuccess(upgradeHistoryMap, standardUpgradeTask, errors, setupMode)) {
                noErrors = false;
                break;
            }
            if (BUILD_NUMBER_COMPARATOR.compare(number, this.getJiraBuildNumber()) > 0) {
                this.setJiraBuildNumber(number);
            }
            reindexRequired = reindexRequired || standardUpgradeTask.isReindexRequired();
        }
        boolean bl = doReindex = noErrors && reindexRequired;
        if (doReindex) {
            this.reindex(errors);
        }
        if (noErrors) {
            this.createUpgradeVersionHistory();
        }
        return new UpgradeManager.Status(doReindex, errors);
    }

    private void setVersions(String buildNumber) {
        this.setJiraBuildNumber(buildNumber);
        try {
            this.scrubUpgradeHistoryNewerThan(buildNumber);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException("Error while scrubbing upgrade history", e);
        }
        this.setJiraVersion(this.buildUtilsInfo.getVersion());
        this.setMinimumDowngradeVersion(this.downgradeUtilsInfo.getDowngradeAllowedVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeManager.Status doSetupUpgrade() {
        UpgradeManager.Status status;
        this.getUpgrades();
        try {
            SortedSet<String> upgradeNumbers = this.getSetupUpgradeBuildNumbers();
            log.info((Object)"___ Performing Setup Upgrade ____________________");
            status = this.runUpgradeTasks(upgradeNumbers, this.setupUpgrades, true);
            if (status.succesful()) {
                this.logUpgradeSuccessfulMsg();
                this.setVersions(this.buildUtilsInfo.getCurrentBuildNumber());
            } else {
                log.error((Object)"Errors occurred during upgrade:");
                this.printErrors(status.getErrors());
            }
        }
        catch (Exception setupUpgradeException) {
            status = this.handleError(setupUpgradeException);
        }
        finally {
            this.releaseUpgrades();
            this.refreshSequencer();
        }
        if (status.succesful()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(true));
        }
        return status;
    }

    private UpgradeManager.Status handleError(Throwable e) {
        log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
        return new UpgradeManager.Status("Exception thrown during upgrade: " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
    }

    private void refreshSequencer() {
        this.ofBizDelegator.refreshSequencer();
    }

    private void getUpgrades() {
        if (this.setupUpgrades == null || this.allUpgrades == null) {
            this.allUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            this.setupUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            this.addAllUpgradesInResourceFile(this.allUpgrades, this.setupUpgrades, this.upgradeTaskFileName);
        }
    }

    private void releaseUpgrades() {
        this.setupUpgrades = null;
        this.allUpgrades = null;
    }

    private void logUpgradeSuccessfulMsg() {
        String msg = "\n\n***************************************************************\nUpgrade Succeeded! JIRA has been upgraded to build number " + this.buildUtilsInfo.getCurrentBuildNumber() + "\n" + "***************************************************************\n";
        log.info((Object)msg);
    }

    private boolean doUpgradeTaskSuccess(Map<String, GenericValue> upgradeHistoryMap, UpgradeTask upgradeTask, Collection<String> errors, boolean setupMode) throws Exception {
        if (upgradeTask != null) {
            if (upgradeHistoryMap.get(upgradeTask.getClass().getName()) == null) {
                log.info((Object)("Performing Upgrade Task: " + upgradeTask.getShortDescription()));
                upgradeTask.doUpgrade(setupMode);
                if (!upgradeTask.getErrors().isEmpty()) {
                    log.error((Object)("Errors during Upgrade Task: " + upgradeTask.getShortDescription()));
                    errors.addAll(upgradeTask.getErrors());
                    return false;
                }
                try {
                    this.addToUpgradeHistory(upgradeTask.getClass());
                }
                catch (DataAccessException e) {
                    log.error((Object)("Problem adding upgrade task " + upgradeTask.getShortDescription() + " to the upgrade history"), (Throwable)e);
                    errors.add("There was a problem adding Upgrade Task " + upgradeTask.getShortDescription() + " to the Upgrade History");
                }
                log.info((Object)("Upgrade Task: '" + upgradeTask.getShortDescription() + "' succeeded"));
            } else {
                log.info((Object)("Not performing Upgrade Task: '" + upgradeTask.getShortDescription() + "' as it has already been run."));
            }
        }
        return true;
    }

    private Map<String, GenericValue> getPreviouslyRunUpgrades() {
        if (this.upgradeHistoryMap == null) {
            List upgradeHistoryList = this.ofBizDelegator.findAll(ENTITY_UPGRADE_HISTORY);
            this.upgradeHistoryMap = new HashMap<String, GenericValue>();
            Iterator i$ = upgradeHistoryList.iterator();
            while (i$.hasNext()) {
                GenericValue element;
                GenericValue upgradeHist = element = (GenericValue)i$.next();
                this.upgradeHistoryMap.put(upgradeHist.getString(FIELD_UPGRADECLASS), upgradeHist);
            }
        }
        return this.upgradeHistoryMap;
    }

    SortedMap<String, UpgradeTask> getRelevantUpgradesFromList(Map<String, UpgradeTask> upgradeMap) {
        try {
            TreeMap<String, UpgradeTask> unAppliedUpgrades = new TreeMap<String, UpgradeTask>(BUILD_NUMBER_COMPARATOR);
            for (Map.Entry<String, UpgradeTask> entry : upgradeMap.entrySet()) {
                if (!this.needUpgrade(entry.getKey())) continue;
                UpgradeTask upgradeTask = entry.getValue();
                unAppliedUpgrades.put(upgradeTask.getBuildNumber(), upgradeTask);
            }
            return unAppliedUpgrades;
        }
        catch (Exception upgradeListRetrievalException) {
            log.error((Object)"An occurred getting the upgrades that need to be run, returning an empty set.", (Throwable)upgradeListRetrievalException);
            return new TreeMap<String, UpgradeTask>();
        }
    }

    private String getJiraBuildNumber() {
        if (this.applicationProperties.getString("jira.version.patched") == null) {
            this.setJiraBuildNumber("0");
        }
        return this.applicationProperties.getString("jira.version.patched");
    }

    private void setJiraBuildNumber(String version) {
        log.info((Object)("Setting current build number to " + version));
        this.applicationProperties.setString("jira.version.patched", version);
    }

    private void setJiraVersion(String version) {
        log.info((Object)("Setting current version to " + version));
        this.applicationProperties.setString("jira.version", version);
    }

    private void setMinimumDowngradeVersion(String version) {
        log.info((Object)("Setting downgrade version to " + version));
        this.applicationProperties.setString("jira.downgrade.minimum.version", version);
    }

    private void scrubUpgradeHistoryNewerThan(String currentBuildNumber) throws GenericEntityException {
        if (!"0".equals(currentBuildNumber)) {
            final long maxBuildNumber = Long.parseLong(currentBuildNumber);
            Predicate<GenericValue> buildNumberPredicate = new Predicate<GenericValue>(){

                public boolean apply(@Nullable GenericValue input) {
                    try {
                        return Long.parseLong(input.getString(UpgradeManagerImpl.FIELD_TARGETBUILD)) > maxBuildNumber;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            ArrayList upgradeTasksToBeScrubbed = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.ofBizDelegator.findAll(ENTITY_UPGRADE_HISTORY), (Predicate)buildNumberPredicate));
            for (GenericValue upgradeTask : upgradeTasksToBeScrubbed) {
                log.info((Object)("Scrubbing upgrade history of task " + upgradeTask.getString(FIELD_UPGRADECLASS)));
                upgradeTask.remove();
            }
            ArrayList upgradeVersionsToBeScrubbed = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.ofBizDelegator.findAll(ENTITY_UPGRADE_VERSION_HISTORY), (Predicate)buildNumberPredicate));
            for (GenericValue upgradeVersion : upgradeVersionsToBeScrubbed) {
                log.info((Object)("Scrubbing upgrade history of build " + upgradeVersion.getString(FIELD_TARGETBUILD)));
                upgradeVersion.remove();
            }
        }
    }

    private boolean needUpgrade(String buildNumber) {
        return this.patchBuildGreaterThanCurrent(this.getJiraBuildNumber(), buildNumber);
    }

    private boolean patchBuildGreaterThanCurrent(String currentBuild, String patchBuild) {
        return BUILD_NUMBER_COMPARATOR.compare(currentBuild, patchBuild) < 0;
    }

    private void addToUpgradeHistory(Class<? extends UpgradeTask> upgradeClass) {
        this.ofBizDelegator.createValue(ENTITY_UPGRADE_HISTORY, MapBuilder.build((Object)FIELD_UPGRADECLASS, (Object)upgradeClass.getName(), (Object)FIELD_TARGETBUILD, (Object)this.buildUtilsInfo.getCurrentBuildNumber()));
    }

    private void createUpgradeVersionHistory() throws GenericEntityException {
        Timestamp timePerformed = new Timestamp(System.currentTimeMillis());
        String currentBuildNumber = this.buildUtilsInfo.getCurrentBuildNumber();
        String version = this.buildUtilsInfo.getVersion();
        try {
            GenericValue record = this.ofBizDelegator.findByPrimaryKey(ENTITY_UPGRADE_VERSION_HISTORY, MapBuilder.build((Object)FIELD_TARGETBUILD, (Object)currentBuildNumber));
            if (record == null) {
                this.ofBizDelegator.createValue(ENTITY_UPGRADE_VERSION_HISTORY, MapBuilder.build((Object)FIELD_TIMEPERFORMED, (Object)timePerformed, (Object)FIELD_TARGETBUILD, (Object)currentBuildNumber, (Object)FIELD_TARGETVERSION, (Object)version));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("A record already exists for build number '" + currentBuildNumber + "' - skipping creation."));
            }
        }
        catch (DataAccessException e) {
            log.error((Object)("Unable to add upgrade version history record : " + version), (Throwable)e);
            throw e;
        }
    }

    SortedMap<String, UpgradeTask> getAllUpgrades() {
        return this.allUpgrades;
    }

    @Override
    public String getExportFilePath() {
        return this.exportFilePath;
    }

    @Override
    public List<UpgradeHistoryItem> getUpgradeHistory() {
        try {
            ArrayList<UpgradeHistoryItem> upgradeHistoryItems = new ArrayList<UpgradeHistoryItem>();
            UpgradeHistoryItem itemFromTasks = this.getUpgradeHistoryItemFromTasks();
            String previousVersion = null;
            String previousBuildNumber = null;
            if (itemFromTasks != null) {
                upgradeHistoryItems.add(itemFromTasks);
                previousVersion = itemFromTasks.getTargetVersion();
                previousBuildNumber = itemFromTasks.getTargetBuildNumber();
            }
            List upgradeTasksWithBuild = this.ofBizDelegator.findAll(ENTITY_UPGRADE_VERSION_HISTORY, CollectionBuilder.list((Object[])new String[]{"id"}));
            for (GenericValue genericValue : upgradeTasksWithBuild) {
                Timestamp timePerformed = genericValue.getTimestamp(FIELD_TIMEPERFORMED);
                String targetBuildNumber = genericValue.getString(FIELD_TARGETBUILD);
                String targetVersion = genericValue.getString(FIELD_TARGETVERSION);
                upgradeHistoryItems.add(new UpgradeHistoryItemImpl(timePerformed, targetBuildNumber, targetVersion, previousBuildNumber, previousVersion));
                previousVersion = targetVersion;
                previousBuildNumber = targetBuildNumber;
            }
            Collections.reverse(upgradeHistoryItems);
            return Collections.unmodifiableList(upgradeHistoryItems);
        }
        catch (GenericEntityException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
    }

    UpgradeHistoryItem getUpgradeHistoryItemFromTasks() throws GenericEntityException {
        GenericValue genericValue;
        String upgradeClassName;
        String buildNumber;
        List upgradeTasksWithoutBuild = this.ofBizDelegator.findByCondition("UpgradeHistoryLastClassForTargetBuild", (EntityCondition)new EntityExpr(FIELD_TARGETBUILD, EntityOperator.EQUALS, null), (Collection)CollectionBuilder.list((Object[])new String[]{FIELD_UPGRADECLASS}), Collections.emptyList());
        if (!upgradeTasksWithoutBuild.isEmpty() && !StringUtils.isBlank((String)(buildNumber = UpgradeManagerImpl.extractBuildNumberFromUpgradeClass(upgradeClassName = (genericValue = (GenericValue)upgradeTasksWithoutBuild.get(0)).getString(FIELD_UPGRADECLASS))))) {
            BuildVersionRegistry.BuildVersion targetVersion = this.buildVersionRegistry.getVersionForBuildNumber(buildNumber);
            return new UpgradeHistoryItemImpl(null, targetVersion.getBuildNumber(), targetVersion.getVersion(), buildNumber, null, true);
        }
        return null;
    }

    static String extractBuildNumberFromUpgradeClass(String upgradeClassName) {
        Pattern pattern = BUILD_NUMBER_PATTERN;
        Matcher matcher = pattern.matcher(upgradeClassName);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    private void setExportFilePath(String exportFilePath) {
        this.exportFilePath = exportFilePath;
    }

    public void reindex(Collection<String> errors) throws Exception {
        log.debug((Object)"Reindex all data if indexing is turned on.");
        boolean indexingOn = this.applicationProperties.getOption("jira.option.indexing");
        if (!indexingOn) {
            log.warn((Object)"Could not reindex data - indexing is turn off. Turn it on in the Administration section.");
        } else {
            this.indexManager.reIndexAll(Contexts.percentageLogger((Sized)this.indexManager, (Logger)log));
        }
    }
}

