/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.startup.ActiveServicesLauncher;
import com.atlassian.jira.startup.BootstrapContainerLauncher;
import com.atlassian.jira.startup.ChecklistLauncher;
import com.atlassian.jira.startup.ClusterPassivationLauncher;
import com.atlassian.jira.startup.ClusteringChecklistLauncher;
import com.atlassian.jira.startup.ClusteringLauncher;
import com.atlassian.jira.startup.ComponentContainerLauncher;
import com.atlassian.jira.startup.DatabaseChecklistLauncher;
import com.atlassian.jira.startup.DatabaseLauncher;
import com.atlassian.jira.startup.FailedPluginsLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.startup.NotificationInstanceKiller;
import com.atlassian.jira.startup.SystemInfoLauncher;
import com.atlassian.jira.upgrade.ConsistencyCheckImpl;
import com.atlassian.jira.upgrade.PluginSystemLauncher;
import com.atlassian.jira.util.devspeed.JiraDevSpeedTimer;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.threadlocal.BruteForceThreadLocalCleanup;
import com.atlassian.threadlocal.RegisteredThreadLocals;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultJiraLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(DefaultJiraLauncher.class);
    private final ChecklistLauncher startupChecklist = new ChecklistLauncher();
    private final BootstrapContainerLauncher bootstrapContainerLauncher = new BootstrapContainerLauncher();
    private final ComponentContainerLauncher componentContainerLauncher = new ComponentContainerLauncher();
    private final NotificationInstanceKiller notificationInstanceKiller = new NotificationInstanceKiller();
    private final DatabaseLauncher databaseLauncher = new DatabaseLauncher();
    private final PluginSystemLauncher pluginSystemLauncher = new PluginSystemLauncher();
    private final ConsistencyCheckImpl consistencyChecker = new ConsistencyCheckImpl();
    private final SystemInfoLauncher systemInfoLauncher = new SystemInfoLauncher();
    private final FailedPluginsLauncher preDbFailedPluginsLauncher = new FailedPluginsLauncher();
    private final FailedPluginsLauncher postDbFailedPluginsLauncher = new FailedPluginsLauncher();
    private final ClusteringLauncher clusteringLauncher = new ClusteringLauncher();
    private final ClusteringChecklistLauncher clusteringChecklistLauncher = new ClusteringChecklistLauncher();
    private final ActiveServicesLauncher activeServicesLauncher = new ActiveServicesLauncher();
    private final ClusterPassivationLauncher clusterPassivationLauncher = new ClusterPassivationLauncher();

    @Override
    public void start() {
        JiraDevSpeedTimer.run(this.getStartupName(), new Runnable(){

            @Override
            public void run() {
                DefaultJiraLauncher.this.preDbLaunch();
                DefaultJiraLauncher.this.postDbLaunch();
            }
        });
        DefaultIndexManager.flushThreadLocalSearchers();
    }

    private void preDbLaunch() {
        this.systemInfoLauncher.start();
        this.bootstrapContainerLauncher.start();
        this.startupChecklist.start();
        this.preDbFailedPluginsLauncher.start();
    }

    private void postDbLaunch() {
        if (JiraStartupChecklist.startupOK()) {
            final DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponentOfType(DatabaseConfigurationManager.class);
            final ServletContext servletContext = ServletContextProvider.getServletContext();
            dbcm.doNowOrWhenDatabaseConfigured(new Runnable(){

                @Override
                public void run() {
                    new DatabaseChecklistLauncher(dbcm, servletContext).start();
                }
            }, "Database Checklist Launcher");
            dbcm.doNowOrWhenDatabaseActivated(new Runnable(){

                @Override
                public void run() {
                    if (!JohnsonEventContainer.get((ServletContext)servletContext).hasEvents()) {
                        DefaultJiraLauncher.this.componentContainerLauncher.start();
                        DefaultJiraLauncher.this.databaseLauncher.start();
                        DefaultJiraLauncher.this.clusteringChecklistLauncher.start();
                        DefaultJiraLauncher.this.clusteringLauncher.start();
                        DefaultJiraLauncher.this.pluginSystemLauncher.start();
                        DefaultJiraLauncher.this.consistencyChecker.initialise(ServletContextProvider.getServletContext());
                        DefaultJiraLauncher.this.activeServicesLauncher.start();
                        DefaultJiraLauncher.this.notificationInstanceKiller.deleteAfterDelay();
                        DefaultJiraLauncher.this.clusterPassivationLauncher.start();
                    }
                }
            }, "Post database-configuration launchers");
            this.postDbFailedPluginsLauncher.start();
        }
    }

    @Override
    public void stop() {
        log.info((Object)"Stopping launchers");
        this.clusterPassivationLauncher.stop();
        this.activeServicesLauncher.stop();
        this.consistencyChecker.destroy(ServletContextProvider.getServletContext());
        this.pluginSystemLauncher.stop();
        this.clusteringLauncher.stop();
        this.databaseLauncher.stop();
        this.componentContainerLauncher.stop();
        this.bootstrapContainerLauncher.stop();
        this.startupChecklist.stop();
        this.systemInfoLauncher.stop();
        this.preDbFailedPluginsLauncher.stop();
        this.postDbFailedPluginsLauncher.stop();
        this.cleanupAfterOurselves();
    }

    private void cleanupAfterOurselves() {
        this.cleanupThreadLocals();
        LogManager.shutdown();
    }

    private void cleanupThreadLocals() {
        Instrumentation.snapshotThreadLocalOperationsAndClear();
        RegisteredThreadLocals.reset();
        BruteForceThreadLocalCleanup.cleanUp((ClassLoader)this.getClass().getClassLoader());
    }

    private String getStartupName() {
        String jvmInputArguments = StringUtils.defaultString((String)RuntimeInformationFactory.getRuntimeInformation().getJvmInputArguments());
        boolean rebel = jvmInputArguments.contains("jrebel.jar");
        boolean debugMode = jvmInputArguments.contains("-Xdebug");
        return "jira.startup" + (debugMode ? ".debug" : ".run") + (rebel ? ".jrebel" : "");
    }
}

