/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.index.CompositeResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionReindexer;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearcher;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultSharePermissionReindexer
implements SharePermissionReindexer {
    private final SharedEntityIndexer indexer;
    private final Set<Reindexer<? extends SharedEntity>> retrievers;

    public DefaultSharePermissionReindexer(SharedEntityIndexer indexer) {
        Assertions.notNull((String)"indexer", (Object)indexer);
        this.indexer = indexer;
        HashSet retrievers = new HashSet(2);
        retrievers.add(new Reindexer(SearchRequest.ENTITY_TYPE));
        retrievers.add(new Reindexer(PortalPage.ENTITY_TYPE));
        this.retrievers = Collections.unmodifiableSet(retrievers);
    }

    @Override
    public void reindex(SharePermission permission) {
        CompositeResultBuilder builder = new CompositeResultBuilder();
        for (Reindexer<? extends SharedEntity> element : this.retrievers) {
            builder.add(element.reindex(permission));
        }
        builder.toResult().await();
    }

    class Reindexer<S extends SharedEntity> {
        private final SharedEntity.TypeDescriptor<S> type;

        private Reindexer(SharedEntity.TypeDescriptor<S> type) {
            this.type = type;
        }

        Index.Result reindex(SharePermission permission) {
            SharedEntitySearchParameters params = new SharedEntitySearchParametersBuilder().setSharePermission((SharePermission)Assertions.notNull((String)"permission", (Object)permission)).toSearchParameters();
            SharedEntitySearcher<S> searcher = DefaultSharePermissionReindexer.this.indexer.getSearcher(this.type);
            Assertions.stateNotNull((String)"searcher", searcher);
            final CompositeResultBuilder builder = new CompositeResultBuilder();
            searcher.search(params).foreach(new Consumer<S>(){

                public void consume(S element) {
                    builder.add(DefaultSharePermissionReindexer.this.indexer.index((SharedEntity)element));
                }
            });
            return builder.toResult();
        }
    }
}

