/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.TimeUnit;

@EventComponent
public class CachingSharePermissionStore
implements SharePermissionStore,
Startable {
    private final SharePermissionStore delegateStore;
    private final Cache<Key, SharedEntity.SharePermissions> cache = CacheBuilder.newBuilder().maximumSize(3000).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Key, SharedEntity.SharePermissions>(){

        public SharedEntity.SharePermissions load(Key key) throws Exception {
            SharedEntity.SharePermissions sharePermissions = CachingSharePermissionStore.this.delegateStore.getSharePermissions(key.entity);
            if (sharePermissions == null) {
                sharePermissions = SharedEntity.SharePermissions.PRIVATE;
            }
            return sharePermissions;
        }
    });

    public CachingSharePermissionStore(SharePermissionStore delegateStore) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.invalidateAll();
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        this.validate(entity);
        SharedEntity.SharePermissions sharePermissions = (SharedEntity.SharePermissions)this.cache.getUnchecked((Object)CachingSharePermissionStore.createKey(entity));
        return sharePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteSharePermissions(SharedEntity entity) {
        this.validate(entity);
        try {
            int n = this.delegateStore.deleteSharePermissions(entity);
            return n;
        }
        finally {
            this.cache.invalidate((Object)CachingSharePermissionStore.createKey(entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteSharePermissionsLike(SharePermission permission) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"permission.type", (Object)permission.getType());
        try {
            int n = this.delegateStore.deleteSharePermissionsLike(permission);
            return n;
        }
        finally {
            this.cache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedEntity.SharePermissions storeSharePermissions(SharedEntity entity) {
        this.validate(entity);
        Assertions.notNull((String)"permissions", (Object)entity.getPermissions());
        try {
            SharedEntity.SharePermissions sharePermissions = this.delegateStore.storeSharePermissions(entity);
            if (sharePermissions == null) {
                sharePermissions = SharedEntity.SharePermissions.PRIVATE;
            }
            SharedEntity.SharePermissions sharePermissions2 = sharePermissions;
            return sharePermissions2;
        }
        finally {
            this.cache.invalidate((Object)CachingSharePermissionStore.createKey(entity));
        }
    }

    private void validate(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.id", (Object)entity.getId());
        Assertions.notNull((String)"entity.entityType", (Object)entity.getEntityType());
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(CachingSharePermissionStore.class.getSimpleName()).addCache(this.cache).install();
    }

    private static Key createKey(SharedEntity entity) {
        return new Key(entity.getId(), entity);
    }

    private static class Key {
        private final long id;
        private final SharedEntity entity;

        public Key(long id, SharedEntity entity) {
            Assertions.notNull((String)"id", (Object)id);
            Assertions.notNull((String)"entity", (Object)entity);
            this.id = id;
            this.entity = entity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.id != key.id) {
                return false;
            }
            return this.entity.getEntityType().equals((Object)key.entity.getEntityType());
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.entity.getEntityType().hashCode();
            return result;
        }

        public String toString() {
            return this.id + ":" + this.entity.getEntityType();
        }
    }
}

