/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.index;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperationFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.util.JiraDurationUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReplicatedIndexCleaningService
extends AbstractService {
    private final Logger log = Logger.getLogger(ReplicatedIndexOperation.class);
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;
    private final ReplicatedIndexOperationFactory factory;
    private final JiraDurationUtils jiraDurationUtils;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private long retentionPeriod;
    public static final String RETENTION_PERIOD = "RETENTION_PERIOD";

    public ReplicatedIndexCleaningService(OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore, JiraDurationUtils jiraDurationUtils, JiraAuthenticationContext jiraAuthenticationContext) {
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
        this.jiraDurationUtils = jiraDurationUtils;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.factory = new ReplicatedIndexOperationFactory();
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(RETENTION_PERIOD)) {
            String retention = this.getProperty(RETENTION_PERIOD);
            try {
                this.retentionPeriod = this.jiraDurationUtils.parseDuration(retention, this.jiraAuthenticationContext.getLocale());
            }
            catch (InvalidDurationException e) {
                this.log.error((Object)"Invalid Duration specified in service configuration", (Throwable)e);
            }
        }
    }

    public void run() {
        Date deleteBeforeTime = new Date(new Date().getTime() - this.retentionPeriod * 1000L);
        this.ofBizReplicatedIndexOperationStore.deleteOperationsBefore(deleteBeforeTime);
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("INDEXCLEANERSERVICE", "services/com/atlassian/jira/service/services/index/indexcleanerservice.xml", null);
    }

    public long getRetentionPeriod() {
        return this.retentionPeriod;
    }
}

