/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.cluster;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.AbstractService;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.log4j.Logger;

public class NodeStateCheckerService
extends AbstractService {
    private final Logger log = Logger.getLogger(ReplicatedIndexOperation.class);
    private final NodeStateManager nodeStateManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private long retentionPeriod;
    public static final String RETENTION_PERIOD = "RETENTION_PERIOD";

    public NodeStateCheckerService(NodeStateManager nodeStateManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.nodeStateManager = nodeStateManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
    }

    public void run() {
        Node node = this.nodeStateManager.getNode();
        if (node.getState() == Node.NodeState.ACTIVE) {
            this.nodeStateManager.refreshState();
            Node refreshedNode = this.nodeStateManager.getNode();
            if (refreshedNode.getState() == Node.NodeState.PASSIVE) {
                try {
                    this.nodeStateManager.deactivate();
                }
                catch (NotClusteredException e) {
                    throw new IllegalStateException("Unclustered node " + node, e);
                }
            }
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("NODESTATECHECKERSERVICE", "services/com/atlassian/jira/service/services/cluster/nodestatecheckerservice.xml", null);
    }
}

