/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericValue;

public class ProjectLead
extends AbstractProjectsSecurityType {
    public static final String DESC = "lead";
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectLead(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.project.lead");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument, User user, boolean issueCreation) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity passed must NOT be null");
        }
        if (!"Project".equals(entity.getEntityName()) && !"Issue".equals(entity.getEntityName())) {
            throw new IllegalArgumentException("Entity passed must be a Project or an Issue not a " + entity.getEntityName());
        }
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        String projectLead = null;
        if ("Project".equals(entity.getEntityName())) {
            projectLead = entity.getString(DESC);
        } else if ("Issue".equals(entity.getEntityName())) {
            GenericValue project = ComponentAccessor.getProjectManager().getProject(entity);
            projectLead = project.getString(DESC);
        }
        return projectLead != null && projectLead.equals(ComponentAccessor.getUserKeyService().getKeyForUser(user));
    }

    @Override
    public boolean hasPermission(Project project, String argument, User user, boolean issueCreation) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        String projectLead = project.getLeadUserKey();
        return projectLead != null && projectLead.equals(ApplicationUsers.getKeyFor((User)user));
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, User user, boolean issueCreation) {
        return this.hasPermission(issue.getProjectObject(), parameter, user, issueCreation);
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String ignored) {
        Project project = ctx.getProjectObject();
        ApplicationUser user = project.getProjectLead();
        HashSet<User> result = new HashSet<User>(1);
        if (user != null) {
            result.add(user.getDirectoryUser());
        }
        return result;
    }

    @Override
    public Query getQuery(User searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        if (project.getLeadUserKey() == null || !project.getLeadUserKey().equals(ApplicationUsers.getKeyFor((User)searcher))) {
            return null;
        }
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("projid", "" + project.getId())), BooleanClause.Occur.MUST);
        query.add(super.getQuery(securityLevel), BooleanClause.Occur.MUST);
        return query;
    }
}

