/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.type.AbstractSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssueFieldSecurityType
extends AbstractSecurityType {
    private static final Logger log = Logger.getLogger(AbstractIssueFieldSecurityType.class);

    protected abstract String getFieldName(String var1);

    @Override
    public Query getQuery(User searcher, Project project, String parameter) {
        if (project == null) {
            return null;
        }
        PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        try {
            Long browsePermission = 10L;
            List schemes = permissionSchemeManager.getSchemes(project.getGenericValue());
            for (GenericValue scheme : schemes) {
                BooleanQuery projectAndUserQuery;
                if (permissionSchemeManager.getEntities(scheme, this.getType(), browsePermission).size() <= 0 || (projectAndUserQuery = this.getQueryForProject(project, searcher, this.getFieldName(parameter))) == null) continue;
                BooleanQuery query = new BooleanQuery();
                query.add((Query)projectAndUserQuery, BooleanClause.Occur.SHOULD);
                return query;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Could not retrieve scheme for this project.", (Throwable)e);
        }
        return null;
    }

    @Override
    public Query getQuery(User searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        BooleanQuery queryForSecurityLevel = this.getQueryForSecurityLevel(securityLevel, searcher, this.getFieldName(parameter));
        if (queryForSecurityLevel == null) {
            return null;
        }
        BooleanQuery query = new BooleanQuery();
        query.add((Query)queryForSecurityLevel, BooleanClause.Occur.MUST);
        return query;
    }

    @Nullable
    protected BooleanQuery getQueryForProject(@Nonnull Project project, @Nullable User searcher, @Nonnull String fieldName) {
        BooleanQuery projectAndUserQuery = null;
        ApplicationUser appSearcher = ApplicationUsers.from((User)searcher);
        if (appSearcher != null) {
            projectAndUserQuery = new BooleanQuery();
            TermQuery projectQuery = new TermQuery(new Term("projid", project.getId().toString()));
            TermQuery userQuery = new TermQuery(new Term(fieldName, appSearcher.getKey()));
            projectAndUserQuery.add((Query)projectQuery, BooleanClause.Occur.MUST);
            projectAndUserQuery.add((Query)userQuery, BooleanClause.Occur.MUST);
        }
        return projectAndUserQuery;
    }

    @Nullable
    protected BooleanQuery getQueryForSecurityLevel(@Nonnull IssueSecurityLevel issueSecurity, @Nullable User searcher, @Nonnull String fieldName) {
        BooleanQuery issueLevelAndUserQuery = null;
        ApplicationUser appSearcher = ApplicationUsers.from((User)searcher);
        if (appSearcher != null) {
            issueLevelAndUserQuery = new BooleanQuery();
            Term securityLevelIsSet = new Term("issue_security_level", issueSecurity.getId().toString());
            Term customFieldSpecifiesUser = new Term(fieldName, appSearcher.getKey());
            issueLevelAndUserQuery.add((Query)new TermQuery(securityLevelIsSet), BooleanClause.Occur.MUST);
            issueLevelAndUserQuery.add((Query)new TermQuery(customFieldSpecifiesUser), BooleanClause.Occur.MUST);
        }
        return issueLevelAndUserQuery;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(GenericValue entity, String argument, User user, boolean issueCreation) {
        if (user != null && entity != null) {
            if ("Issue".equals(entity.getEntityName())) {
                return this.hasIssuePermission(user, issueCreation, entity, argument);
            }
            if ("Project".equals(entity.getEntityName())) {
                return this.hasProjectPermission(user, issueCreation, entity);
            }
        }
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, User user, boolean issueCreation) {
        if (user == null || issue == null) {
            return false;
        }
        return this.hasIssuePermission(user, issueCreation, issue, parameter);
    }

    @Override
    public boolean hasPermission(Project project, String parameter, User user, boolean issueCreation) {
        if (user == null || project == null) {
            return false;
        }
        return this.hasProjectPermission(user, issueCreation, project);
    }

    protected abstract boolean hasIssuePermission(User var1, boolean var2, GenericValue var3, String var4);

    protected abstract boolean hasIssuePermission(User var1, boolean var2, Issue var3, String var4);

    protected abstract boolean hasProjectPermission(User var1, boolean var2, GenericValue var3);

    protected abstract boolean hasProjectPermission(User var1, boolean var2, Project var3);
}

