/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.security.auth.trustedapps.AuditLog;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.security.auth.trustedapps.SimpleTrustedApplication;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationUtil;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class TrustedApplicationBuilder {
    private long id;
    private String applicationId;
    private long timeout;
    private String publicKey;
    private String name;
    private String ipMatch;
    private String urlMatch;
    private String createdBy;
    private String updatedBy;
    private Date created;
    private Date updated;

    TrustedApplicationBuilder set(GenericValue gv) {
        Null.not("genericValue", gv);
        if (!"TrustedApplication".equals(gv.getEntityName())) {
            throw new IllegalArgumentException("Cannot build a TrustedApplication from a " + gv.getEntityName());
        }
        Long idLong = gv.getLong("id");
        this.setId(idLong == null ? 0L : idLong);
        this.setApplicationId(gv.getString("applicationId"));
        this.setCreatedBy(gv.getString("createdBy"));
        this.setCreated(gv.getTimestamp("created"));
        this.setUpdatedBy(gv.getString("updatedBy"));
        this.setUpdated(gv.getTimestamp("updated"));
        this.setName(gv.getString("name"));
        this.setPublicKey(gv.getString("publicKey"));
        this.setTimeout(gv.getLong("timeout"));
        this.setIpMatch(gv.getString("ipMatch"));
        this.setUrlMatch(gv.getString("urlMatch"));
        return this;
    }

    TrustedApplicationBuilder set(TrustedApplicationData data) {
        Null.not("data", data);
        this.setId(data.getId());
        this.setApplicationId(data.getApplicationId());
        this.setTimeout(data.getTimeout());
        this.setPublicKey(data.getPublicKey());
        this.setName(data.getName());
        this.setIpMatch(data.getIpMatch());
        this.setUrlMatch(data.getUrlMatch());
        this.setCreated(data.getCreated());
        this.setUpdated(data.getUpdated());
        return this;
    }

    public TrustedApplicationBuilder set(TrustedApplicationInfo info) {
        Null.not("info", (Object)info);
        this.setId(info.getNumericId());
        this.setApplicationId(info.getID());
        this.setTimeout(info.getTimeout());
        this.setPublicKey(info.getPublicKey());
        this.setName(info.getName());
        this.setIpMatch(info.getIpMatch());
        this.setUrlMatch(info.getUrlMatch());
        return this;
    }

    public TrustedApplicationBuilder set(Application app) {
        Null.not("app", app);
        this.setApplicationId(app.getID());
        this.setPublicKey(app.getPublicKey());
        return this;
    }

    public TrustedApplicationBuilder set(RequestConditions requestConditions) {
        Null.not("requestConditions", requestConditions);
        this.setTimeout(requestConditions.getCertificateTimeout());
        this.setUrlMatch(requestConditions.getURLPatterns());
        this.setIpMatch(requestConditions.getIPPatterns());
        return this;
    }

    public long getId() {
        return this.id;
    }

    public TrustedApplicationBuilder setId(long id) {
        this.id = id;
        return this;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public TrustedApplicationBuilder setApplicationId(String applicationId) {
        Null.not("applicationId", applicationId);
        this.applicationId = applicationId;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TrustedApplicationBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public TrustedApplicationBuilder setPublicKey(PublicKey publicKey) {
        Null.not("publicKey", publicKey);
        this.publicKey = KeyFactory.encode(publicKey);
        return this;
    }

    public TrustedApplicationBuilder setPublicKey(String publicKey) {
        Null.not("publicKey", publicKey);
        this.publicKey = publicKey;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TrustedApplicationBuilder setName(String name) {
        Null.not("name", name);
        this.name = name;
        return this;
    }

    public String getIpMatch() {
        return this.ipMatch;
    }

    public TrustedApplicationBuilder setIpMatch(String ipMatch) {
        this.ipMatch = TrustedApplicationUtil.canonicalize(ipMatch);
        return this;
    }

    public TrustedApplicationBuilder setIpMatch(Iterable<String> ipMatch) {
        this.ipMatch = TrustedApplicationUtil.canonicalize(ipMatch);
        return this;
    }

    public String getUrlMatch() {
        return this.urlMatch;
    }

    public TrustedApplicationBuilder setUrlMatch(String urlMatch) {
        this.urlMatch = TrustedApplicationUtil.canonicalize(urlMatch);
        return this;
    }

    private TrustedApplicationBuilder setUrlMatch(Iterable<String> urlPatterns) {
        this.urlMatch = TrustedApplicationUtil.canonicalize(urlPatterns);
        return this;
    }

    TrustedApplicationBuilder setCreatedBy(String createdBy) {
        Null.not("createdBy", createdBy);
        this.createdBy = createdBy;
        return this;
    }

    TrustedApplicationBuilder setUpdatedBy(String updatedBy) {
        Null.not("updatedBy", updatedBy);
        this.updatedBy = updatedBy;
        return this;
    }

    public TrustedApplicationBuilder setCreated(Date created) {
        Null.not("created", created);
        this.created = new Date(created.getTime());
        return this;
    }

    TrustedApplicationBuilder setUpdated(Date updated) {
        Null.not("updated", updated);
        this.updated = new Date(updated.getTime());
        return this;
    }

    public TrustedApplicationBuilder setCreated(AuditLog created) {
        Null.not("created", created);
        this.setCreatedBy(created.getWho());
        this.setCreated(created.getWhen());
        return this;
    }

    TrustedApplicationBuilder setUpdated(AuditLog updated) {
        Null.not("updated", updated);
        this.setUpdatedBy(updated.getWho());
        this.setUpdated(updated.getWhen());
        return this;
    }

    public TrustedApplicationInfo toInfo() {
        try {
            return new TrustedApplicationInfo(this.id, this.applicationId, this.name, this.timeout, this.ipMatch, this.urlMatch, KeyFactory.getPublicKey(this.publicKey));
        }
        catch (IllegalArgumentException e) {
            IllegalStateException exception = new IllegalStateException(e.toString());
            exception.initCause(e);
            throw exception;
        }
    }

    public SimpleTrustedApplication toSimple() {
        return new Simple(this);
    }

    public TrustedApplicationData toData() {
        try {
            return new TrustedApplicationData(this.id, this.applicationId, this.name, this.publicKey, this.timeout, new AuditLog(this.createdBy, this.created), new AuditLog(this.updatedBy, this.updated), this.ipMatch, this.urlMatch);
        }
        catch (IllegalArgumentException e) {
            IllegalStateException exception = new IllegalStateException(e.toString());
            exception.initCause(e);
            throw exception;
        }
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.id > 0L) {
            map.put("id", this.id);
        }
        map.put("applicationId", this.applicationId);
        map.put("name", this.name);
        map.put("publicKey", this.publicKey);
        map.put("timeout", this.timeout);
        map.put("created", new Timestamp(this.created.getTime()));
        map.put("createdBy", this.createdBy);
        map.put("updated", new Timestamp(this.updated.getTime()));
        map.put("updatedBy", this.updatedBy);
        map.put("ipMatch", this.ipMatch);
        map.put("urlMatch", this.urlMatch);
        return map;
    }

    @HtmlSafe
    public String toQueryString() {
        class QueryBuilder {
            StringBuffer buffer = new StringBuffer();

            QueryBuilder() {
            }

            QueryBuilder add(String name, Object value) {
                if (value != null) {
                    if (this.buffer.length() > 0) {
                        this.buffer.append("&");
                    }
                    try {
                        this.buffer.append(name).append("=").append(URLEncoder.encode(String.valueOf(value), "UTF8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this;
            }
        }
        QueryBuilder result = new QueryBuilder();
        result.add("id", this.getId());
        result.add("applicationId", this.getApplicationId());
        result.add("name", this.getName());
        result.add("publicKey", this.getPublicKey());
        result.add("timeout", this.getTimeout());
        result.add("ipMatch", this.getIpMatch());
        result.add("urlMatch", this.getUrlMatch());
        return result.buffer.toString();
    }

    static final class Simple
    implements SimpleTrustedApplication {
        final long id;
        final String applicationId;
        final long timeout;
        final String publicKey;
        final String name;
        final String ipMatch;
        final String urlMatch;

        Simple(TrustedApplicationBuilder builder) {
            this.id = builder.id;
            this.applicationId = builder.applicationId;
            this.timeout = builder.timeout;
            this.publicKey = builder.publicKey;
            this.name = builder.name;
            this.ipMatch = builder.ipMatch;
            this.urlMatch = builder.urlMatch;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getIpMatch() {
            return this.ipMatch;
        }

        @Override
        public String getUrlMatch() {
            return this.urlMatch;
        }
    }
}

