/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.util.dbc.Null;
import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.commons.codec.binary.Base64;

public class KeyFactory {
    public static EncryptionProvider getEncryptionProvider() {
        return new BouncyCastleEncryptionProvider();
    }

    static PublicKey getPublicKey(String keyStr) {
        Null.not("keyStr", keyStr);
        byte[] data = Base64.decodeBase64((byte[])keyStr.getBytes());
        try {
            return KeyFactory.getEncryptionProvider().toPublicKey(data);
        }
        catch (NoSuchProviderException e) {
            return new InvalidPublicKey(e);
        }
        catch (NoSuchAlgorithmException e) {
            return new InvalidPublicKey(e);
        }
        catch (InvalidKeySpecException e) {
            return new InvalidPublicKey(e);
        }
    }

    static PrivateKey getPrivateKey(String keyStr) {
        Null.not("keyStr", keyStr);
        byte[] data = Base64.decodeBase64((byte[])keyStr.getBytes());
        try {
            return KeyFactory.getEncryptionProvider().toPrivateKey(data);
        }
        catch (NoSuchProviderException e) {
            return new InvalidPrivateKey(e);
        }
        catch (NoSuchAlgorithmException e) {
            return new InvalidPrivateKey(e);
        }
        catch (InvalidKeySpecException e) {
            return new InvalidPrivateKey(e);
        }
    }

    static String encode(Key key) {
        return new String(Base64.encodeBase64((byte[])key.getEncoded()));
    }

    private KeyFactory() {
    }

    static class InvalidKey
    implements Key {
        private final Exception cause;

        public InvalidKey(Exception cause) {
            Null.not("cause", cause);
            this.cause = cause;
        }

        @Override
        public String getAlgorithm() {
            return "";
        }

        @Override
        public String getFormat() {
            return "";
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        public String toString() {
            return "Invalid Key: " + this.cause.toString();
        }

        public Exception getCause() {
            return this.cause;
        }
    }

    public static class InvalidPublicKey
    extends InvalidKey
    implements PublicKey {
        public InvalidPublicKey(Exception cause) {
            super(cause);
        }
    }

    public static class InvalidPrivateKey
    extends InvalidKey
    implements PrivateKey {
        public InvalidPrivateKey(Exception cause) {
            super(cause);
        }
    }
}

