/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.WorkflowPermission;
import com.atlassian.jira.permission.WorkflowPermissionFactory;
import com.atlassian.jira.security.DefaultPermissionManager;
import com.atlassian.jira.security.Permissions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowBasedPermissionManager
extends DefaultPermissionManager {
    private static final Logger log = Logger.getLogger(WorkflowBasedPermissionManager.class);
    private final WorkflowPermissionFactory workflowPermissionFactory;
    private final PermissionContextFactory permissionContextFactory;

    public WorkflowBasedPermissionManager(WorkflowPermissionFactory workflowPermissionFactory, PermissionContextFactory permissionContextFactory) {
        this.workflowPermissionFactory = workflowPermissionFactory;
        this.permissionContextFactory = permissionContextFactory;
    }

    @Override
    @SuppressWarnings(value={"NM_WRONG_PACKAGE"}, justification="OSUser is deprecated and dying anyway. Plus the method in question is final so we can't override it.")
    public boolean hasPermission(int permissionId, GenericValue entity, User user, boolean issueCreation) {
        boolean permSchemeAllows = super.hasPermission(permissionId, entity, user, issueCreation);
        String permName = Permissions.getShortName((int)permissionId);
        if (permSchemeAllows) {
            if ("Issue".equals(entity.getEntityName())) {
                MutableIssue issue = ComponentAccessor.getIssueFactory().getIssue(entity);
                List<WorkflowPermission> workflowPerms = this.workflowPermissionFactory.getWorkflowPermissions(this.permissionContextFactory.getPermissionContext((Issue)issue), permissionId, false);
                this.addParentPermissionsIfSubTask(workflowPerms, (Issue)issue, permissionId);
                if (!workflowPerms.isEmpty()) {
                    for (WorkflowPermission permission : workflowPerms) {
                        if (permission.allows(permissionId, (Issue)issue, user)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)(permName + " granted by permission scheme and " + permission));
                            }
                            return true;
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("\t" + permName + " not granted by " + permission));
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)(permName + " granted by permission scheme but DENIED by workflow"));
                    }
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(permName + " granted by permission scheme"));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(permName + " permission granted by permission scheme"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(permName + " permission denied by permission scheme"));
        }
        return false;
    }

    private void addParentPermissionsIfSubTask(List<WorkflowPermission> workflowPerms, Issue issue, int permissionId) {
        SubTaskManager subTaskManager = ComponentManager.getInstance().getSubTaskManager();
        Issue parent = issue.getParentObject();
        if (subTaskManager.isSubTasksEnabled() && parent != null) {
            PermissionContext parentPermissionContext = this.permissionContextFactory.getPermissionContext(parent);
            workflowPerms.addAll(this.workflowPermissionFactory.getWorkflowPermissions(parentPermissionContext, permissionId, true));
        }
    }
}

