/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.scheme.AbstractProjectAndSchemeAwareAction;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSelectProjectScheme
extends AbstractProjectAndSchemeAwareAction {
    private String[] schemeIds = new String[]{""};

    public String doDefault() throws Exception {
        Collection schemeIds;
        if (this.getProject() != null && !(schemeIds = Collections2.transform((Collection)this.getSchemeManager().getSchemes(this.getProject()), (Function)new Function<GenericValue, String>(){

            public String apply(GenericValue scheme) {
                return scheme.getLong("id").toString();
            }
        })).isEmpty()) {
            this.setSchemeIds(schemeIds.toArray(new String[schemeIds.size()]));
        }
        if (this.hasPermission()) {
            return super.doDefault();
        }
        return "securitybreach";
    }

    protected void doValidation() {
        if (this.getProjectObject() == null) {
            this.addErrorMessage("You must select a project for this scheme");
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getSchemeManager().removeSchemesFromProject(this.getProjectObject());
        for (String schemeId : this.getSchemeIds()) {
            if (!TextUtils.stringSet((String)schemeId)) continue;
            Scheme scheme = this.getSchemeManager().getSchemeObject(new Long(schemeId));
            this.getSchemeManager().addSchemeToProject(this.getProjectObject(), scheme);
        }
        if (this.hasPermission()) {
            return this.getRedirect(this.getProjectReturnUrl());
        }
        return "securitybreach";
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    protected String getProjectReturnUrl() {
        return "/plugins/servlet/project-config/" + this.getProjectObject().getKey() + "/summary";
    }

    protected boolean hasPermission() {
        return this.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public Collection<GenericValue> getSchemes() throws GenericEntityException {
        return this.getSchemeManager().getSchemes();
    }

    public String[] getSchemeIds() {
        return this.schemeIds;
    }

    public void setSchemeIds(String[] schemeIds) {
        this.schemeIds = schemeIds;
    }
}

