/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class PropertySetCache {
    private static final Logger log = Logger.getLogger(PropertySetCache.class);
    private final ConcurrentHashMap<String, Object> valueCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> typeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Boolean> existanceCache = new ConcurrentHashMap();
    private static final Object NULL_TOKEN = new Object();

    PropertySetCache() {
    }

    public void setBoolean(String key, boolean value) {
        this.setObject(key, value);
    }

    public boolean getBoolean(String key) throws NoValueCachedException {
        Object value = this.valueCache.get(key);
        if (value == NULL_TOKEN) {
            return false;
        }
        if (value == null) {
            throw new NoValueCachedException();
        }
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a boolean, but it is the wrong type.");
        }
    }

    public void setData(String key, byte[] value) {
        this.setObject(key, value);
    }

    public byte[] getData(String key) throws NoValueCachedException {
        try {
            return (byte[])this.getObject(key);
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a byte[], but it is the wrong type.");
        }
    }

    public void setDate(String key, Date value) {
        this.setObject(key, value);
    }

    public Date getDate(String key) throws NoValueCachedException {
        try {
            return (Date)this.getObject(key);
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a Date, but it is the wrong type.");
        }
    }

    public void setDouble(String key, double value) {
        this.setObject(key, value);
    }

    public double getDouble(String key) throws NoValueCachedException {
        try {
            Double value = (Double)this.getObject(key);
            if (value == null) {
                return 0.0;
            }
            return value;
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a double, but it is the wrong type.");
        }
    }

    public void setInt(String key, int value) {
        this.setObject(key, value);
    }

    public int getInt(String key) throws NoValueCachedException {
        try {
            Integer value = (Integer)this.getObject(key);
            if (value == null) {
                return 0;
            }
            return value;
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as an int, but it is the wrong type.");
        }
    }

    public void setLong(String key, long value) {
        this.setObject(key, value);
    }

    public long getLong(String key) throws NoValueCachedException {
        try {
            Long value = (Long)this.getObject(key);
            if (value == null) {
                return 0L;
            }
            return value;
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a long, but it is the wrong type.");
        }
    }

    public void setObject(String key, Object value) {
        if (value == null) {
            this.valueCache.put(key, NULL_TOKEN);
            this.typeCache.remove(key);
            this.existanceCache.remove(key);
        } else {
            this.valueCache.put(key, value);
            this.typeCache.remove(key);
            this.existanceCache.put(key, Boolean.TRUE);
        }
    }

    public Object getObject(String key) throws NoValueCachedException {
        Object value = this.valueCache.get(key);
        if (value == NULL_TOKEN) {
            return null;
        }
        if (value == null) {
            throw new NoValueCachedException();
        }
        return value;
    }

    public void setProperties(String key, Properties value) {
        this.setObject(key, value);
    }

    public Properties getProperties(String key) throws NoValueCachedException {
        try {
            return (Properties)this.getObject(key);
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a Properties object, but it is the wrong type.");
        }
    }

    public void setString(String key, String value) {
        this.setObject(key, value);
    }

    public String getString(String key) throws NoValueCachedException, InvalidPropertyTypeException {
        try {
            return (String)this.getObject(key);
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a String, but it is the wrong type.");
        }
    }

    public void setText(String key, String value) {
        this.setObject(key, value);
    }

    public String getText(String key) throws NoValueCachedException {
        return this.getString(key);
    }

    public void setXML(String key, Document value) {
        this.setObject(key, value);
    }

    public Document getXML(String key) throws NoValueCachedException {
        try {
            return (Document)this.getObject(key);
        }
        catch (ClassCastException ex) {
            throw new InvalidPropertyTypeException("Tried to retrieve PropertySet key '" + key + "' as a DOM Document, but it is the wrong type.");
        }
    }

    public void remove(String key) {
        this.valueCache.put(key, NULL_TOKEN);
        this.typeCache.remove(key);
        this.existanceCache.put(key, Boolean.FALSE);
    }

    public void clear() {
        this.valueCache.clear();
        this.typeCache.clear();
        this.existanceCache.clear();
    }

    public void bulkLoad(PropertySet source) {
        for (Object key : source.getKeys()) {
            try {
                this.cloneProperty((String)key, source);
            }
            catch (PropertyException ex) {
                log.error((Object)("Unable to clone property '" + key + "' in PropertySet."), (Throwable)ex);
            }
        }
    }

    private void cloneProperty(String key, PropertySet source) throws PropertyException {
        switch (source.getType(key)) {
            case 1: {
                this.setBoolean(key, source.getBoolean(key));
                break;
            }
            case 2: {
                this.setInt(key, source.getInt(key));
                break;
            }
            case 3: {
                this.setLong(key, source.getLong(key));
                break;
            }
            case 4: {
                this.setDouble(key, source.getDouble(key));
                break;
            }
            case 5: {
                this.setString(key, source.getString(key));
                break;
            }
            case 6: {
                this.setText(key, source.getText(key));
                break;
            }
            case 7: {
                this.setDate(key, source.getDate(key));
                break;
            }
            case 8: {
                this.setObject(key, source.getObject(key));
                break;
            }
            case 9: {
                this.setXML(key, source.getXML(key));
                break;
            }
            case 10: {
                this.setData(key, source.getData(key));
                break;
            }
            case 11: {
                this.setProperties(key, source.getProperties(key));
            }
        }
    }

    public Boolean exists(String key) {
        return this.existanceCache.get(key);
    }

    public void cacheExistance(String key, boolean keyExists) {
        this.existanceCache.put(key, keyExists);
    }

    public void setType(String key, int type) {
        this.typeCache.put(key, type);
    }

    public int getType(String key) throws NoValueCachedException {
        Integer type = this.typeCache.get(key);
        if (type == null) {
            throw new NoValueCachedException();
        }
        return type;
    }

    final class NoValueCachedException
    extends Exception {
        NoValueCachedException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

