/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class ProjectKeyStoreImpl
implements ProjectKeyStore {
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_ID = "projectId";
    private static String ENTITY_NAME = "ProjectKey";
    private final OfBizDelegator ofBizDelegator;

    public ProjectKeyStoreImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Long getProjectId(String key) {
        GenericValue gv = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)PROJECT_KEY, (Object)key)));
        return gv != null ? gv.getLong(PROJECT_ID) : null;
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.ofBizDelegator.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)PROJECT_ID, (Object)projectId, (Object)PROJECT_KEY, (Object)projectKey));
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        Delete.from("ProjectKey").whereEqual(PROJECT_ID, projectId).execute(this.ofBizDelegator);
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        List keys = this.ofBizDelegator.findAll(ENTITY_NAME);
        if (keys == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (GenericValue key : keys) {
            result.put(key.getString(PROJECT_KEY), key.getLong(PROJECT_ID));
        }
        return result;
    }

    @Override
    public Set<String> getProjectKeys(Long projectId) {
        List keys = this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)PROJECT_ID, (Object)projectId));
        if (keys == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)keys, (Function)new Function<GenericValue, String>(){

            public String apply(GenericValue input) {
                return input.getString(ProjectKeyStoreImpl.PROJECT_KEY);
            }
        }));
    }
}

