/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPermissionPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Map;

public class WorkflowUserPermissionValidatorPluginFactory
extends AbstractWorkflowPermissionPluginFactory
implements WorkflowPluginValidatorFactory {
    private final SchemePermissions schemePermissions;

    public WorkflowUserPermissionValidatorPluginFactory(SchemePermissions schemePermissions) {
        super(schemePermissions);
        this.schemePermissions = schemePermissions;
    }

    @Override
    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        super.getVelocityParamsForInput(velocityParams);
        velocityParams.put("nullallowedoptions", EasyMap.build((Object)Boolean.TRUE.toString(), (Object)"True", (Object)Boolean.FALSE.toString(), (Object)"False"));
    }

    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        if (!(descriptor instanceof ValidatorDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        }
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        String shortName = (String)args.get("permission");
        int permissionId = Permissions.getType((String)shortName);
        velocityParams.put("permission", new Integer(permissionId));
        velocityParams.put("vars-key", args.get("vars.key"));
        velocityParams.put("nullallowed", args.get("nullallowed"));
    }

    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof ValidatorDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        }
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        String shortName = (String)args.get("permission");
        int permissionId = Permissions.getType((String)shortName);
        velocityParams.put("permission", this.schemePermissions.getPermissionName(new Integer(permissionId)));
        velocityParams.put("vars-key", args.get("vars.key"));
        velocityParams.put("nullallowed", Boolean.valueOf((String)args.get("nullallowed")));
    }

    protected Map<String, String> createMap(Map<String, String> extractedParams) {
        if (extractedParams.containsKey("permission")) {
            String value = extractedParams.get("permission");
            int permissionId = Integer.parseInt(value);
            extractedParams.put("permission", Permissions.getShortName((int)permissionId));
        }
        return extractedParams;
    }

    public Map<String, ?> getDescriptorParams(Map<String, Object> conditionParams) {
        return this.extractMultipleParams(conditionParams, CollectionBuilder.newBuilder((Object[])new String[]{"permission", "vars.key", "nullallowed"}).asList());
    }
}

