/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.model;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SettableWebLink;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JiraWebLink
implements WebLink,
SettableWebLink {
    private WebLink webLink;
    private final JiraAuthenticationContext authenticationContext;

    public JiraWebLink(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public JiraWebLink(WebLink webLink, JiraAuthenticationContext authenticationContext) {
        this.webLink = webLink;
        this.authenticationContext = authenticationContext;
    }

    public String getRenderedUrl(User remoteUser, JiraHelper jiraHelper) {
        return this.webLink.getRenderedUrl(this.makeContext(remoteUser, jiraHelper));
    }

    public String getDisplayableUrl(User remoteUser, JiraHelper jiraHelper) {
        return this.webLink.getDisplayableUrl(jiraHelper.getRequest(), this.makeContext(remoteUser, jiraHelper));
    }

    public boolean hasAccessKey() {
        return this.webLink.hasAccessKey();
    }

    public String getAccessKey(User remoteUser, JiraHelper jiraHelper) {
        return this.webLink.getAccessKey(this.makeContext(remoteUser, jiraHelper));
    }

    public String getId() {
        return this.webLink.getId();
    }

    protected Map makeContext(User remoteUser, JiraHelper jiraHelper) {
        Map params = EasyMap.build((Object)"user", (Object)remoteUser, (Object)"helper", (Object)jiraHelper, (Object)"i18n", (Object)this.authenticationContext.getI18nHelper());
        params.putAll(jiraHelper.getContextParams());
        return params;
    }

    public String getRenderedUrl(Map context) {
        return this.webLink.getRenderedUrl(context);
    }

    public String getDisplayableUrl(HttpServletRequest req, Map context) {
        return this.webLink.getDisplayableUrl(req, context);
    }

    public String getAccessKey(Map context) {
        return this.webLink.getAccessKey(context);
    }

    public WebFragmentModuleDescriptor getDescriptor() {
        return this.webLink.getDescriptor();
    }

    @Override
    public void setLink(WebLink link) {
        this.webLink = link;
    }
}

