/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

class SubTaskingIssueDecorator
implements Issue {
    private final Issue issue;
    private final Set<Issue> subTasks = new HashSet<Issue>();

    public SubTaskingIssueDecorator(Issue issue) {
        this.issue = issue;
    }

    void addSubTask(Issue subTask) {
        if (subTask == null) {
            throw new IllegalArgumentException("subtask cannot be null");
        }
        if (!this.subTasks.add(subTask)) {
            throw new IllegalArgumentException("Issue " + this.issue.getKey() + " already contains " + subTask.getKey() + " subtask");
        }
    }

    Issue getDecoratedIssue() {
        return this.issue;
    }

    public Collection<Version> getAffectedVersions() {
        return this.issue.getAffectedVersions();
    }

    public User getAssigneeUser() {
        return this.issue.getAssigneeUser();
    }

    public User getAssignee() {
        return this.issue.getAssignee();
    }

    public String getAssigneeId() {
        return this.issue.getAssigneeId();
    }

    public Collection<Attachment> getAttachments() {
        return this.issue.getAttachments();
    }

    public Collection<GenericValue> getComponents() {
        return this.issue.getComponents();
    }

    public Collection<ProjectComponent> getComponentObjects() {
        return this.issue.getComponentObjects();
    }

    public Timestamp getCreated() {
        return this.issue.getCreated();
    }

    public Timestamp getResolutionDate() {
        return this.issue.getResolutionDate();
    }

    public Object getCustomFieldValue(CustomField customField) {
        return this.issue.getCustomFieldValue(customField);
    }

    public String getDescription() {
        return this.issue.getDescription();
    }

    public Timestamp getDueDate() {
        return this.issue.getDueDate();
    }

    public String getEnvironment() {
        return this.issue.getEnvironment();
    }

    public Long getEstimate() {
        return this.issue.getEstimate();
    }

    public Object getExternalFieldValue(String fieldId) {
        return this.issue.getExternalFieldValue(fieldId);
    }

    public Collection<Version> getFixVersions() {
        return this.issue.getFixVersions();
    }

    public Long getId() {
        return this.issue.getId();
    }

    public IssueRenderContext getIssueRenderContext() {
        return this.issue.getIssueRenderContext();
    }

    public GenericValue getIssueType() {
        return this.issue.getIssueType();
    }

    public IssueType getIssueTypeObject() {
        return this.issue.getIssueTypeObject();
    }

    public String getIssueTypeId() {
        return this.issue.getIssueTypeId();
    }

    public String getKey() {
        return this.issue.getKey();
    }

    public Long getNumber() {
        return this.issue.getNumber();
    }

    public Long getOriginalEstimate() {
        return this.issue.getOriginalEstimate();
    }

    public GenericValue getParent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("GenericValue accessors are not supported!");
    }

    public Long getParentId() {
        return this.issue.getParentId();
    }

    public Issue getParentObject() {
        return this.issue.getParentObject();
    }

    public GenericValue getPriority() {
        return this.issue.getPriority();
    }

    public Priority getPriorityObject() {
        return this.issue.getPriorityObject();
    }

    public GenericValue getProject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("GenericValue accessors are not supported!");
    }

    public Project getProjectObject() {
        return this.issue.getProjectObject();
    }

    public Long getProjectId() {
        return this.issue.getProjectId();
    }

    public User getReporterUser() {
        return this.issue.getReporterUser();
    }

    public User getReporter() {
        return this.issue.getReporter();
    }

    public String getReporterId() {
        return this.issue.getReporterId();
    }

    public String getResolutionId() {
        return this.issue.getResolutionId();
    }

    public GenericValue getResolution() {
        return this.issue.getResolution();
    }

    public Resolution getResolutionObject() {
        return this.issue.getResolutionObject();
    }

    public GenericValue getSecurityLevel() {
        return this.issue.getSecurityLevel();
    }

    public Long getSecurityLevelId() {
        return this.issue.getSecurityLevelId();
    }

    public GenericValue getStatus() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("GenericValue accessors are not supported!");
    }

    public Status getStatusObject() {
        return this.issue.getStatusObject();
    }

    public Set<Label> getLabels() {
        return this.issue.getLabels();
    }

    public Collection<Issue> getSubTaskObjects() {
        return Collections.unmodifiableSet(this.subTasks);
    }

    public Collection<GenericValue> getSubTasks() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("GenericValue subtasks are not supported. Use getSubTaskObjects() method.");
    }

    public String getSummary() {
        return this.issue.getSummary();
    }

    public Long getTimeSpent() {
        return this.issue.getTimeSpent();
    }

    public Timestamp getUpdated() {
        return this.issue.getUpdated();
    }

    public Long getVotes() {
        return this.issue.getVotes();
    }

    public Long getWatches() {
        return this.issue.getWatches();
    }

    public Long getWorkflowId() {
        return this.issue.getWorkflowId();
    }

    public boolean isCreated() {
        return this.issue.isCreated();
    }

    public boolean isEditable() {
        return this.issue.isEditable();
    }

    public boolean isSubTask() {
        return this.issue.isSubTask();
    }

    public GenericValue getGenericValue() {
        return this.issue.getGenericValue();
    }

    public Long getLong(String name) {
        return this.issue.getLong(name);
    }

    public String getString(String name) {
        return this.issue.getString(name);
    }

    public Timestamp getTimestamp(String name) {
        return this.issue.getTimestamp(name);
    }

    public void store() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Reports should not be persisting Issues!");
    }

    public int hashCode() {
        return this.issue.hashCode();
    }

    public boolean equals(Object obj) {
        return this.issue.equals(obj);
    }

    public String toString() {
        return this.issue.toString();
    }
}

