/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ActivityStreamFragment
extends AbstractFragment {
    protected static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/";
    private static final String ACTIVTY_STREAM_GADGET_MODULE_KEY = "com.atlassian.streams.streams-jira-plugin:activitystream-gadget";
    private static final String WEB_PANEL_LOCATION = "webpanels.browse.project.summary.activitystream";
    private final PluginAccessor pluginAccessor;
    private final WebInterfaceManager webInterfaceManager;

    public ActivityStreamFragment(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext jiraAuthenticationContext, PluginAccessor pluginAccessor, WebInterfaceManager webInterfaceManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.pluginAccessor = pluginAccessor;
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> params = super.createVelocityParams(ctx);
        String projectKey = ctx.getProject().getKey();
        params.put("gadgetHtml", this.getPanelHtml(projectKey));
        return params;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    public String getId() {
        return "activitystream";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        GadgetViewFactory viewFactory = ComponentManager.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        return viewFactory != null && this.pluginAccessor.isPluginModuleEnabled(ACTIVTY_STREAM_GADGET_MODULE_KEY) && this.getIssueCountInSearch(ctx) > 0L;
    }

    public String getPanelHtml(String projectKey) {
        StringBuilder sb = new StringBuilder();
        Map context = MapBuilder.newBuilder().add((Object)"projectKey", (Object)projectKey).toMap();
        List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(WEB_PANEL_LOCATION, Collections.emptyMap());
        for (WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
            sb.append(((WebPanel)webPanelDescriptor.getModule()).getHtml(context));
        }
        return sb.toString();
    }
}

