/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractUserBasedFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.List;

public class ComponentsLeadByUserFunction
extends AbstractUserBasedFunction {
    public static final String FUNCTION_COMPONENTS_LEAD_BY_USER = "componentsLeadByUser";
    private static final String JIRA_JQL_COMPONENT_NO_SUCH_USER = "jira.jql.component.no.such.user";
    private final PermissionManager permissionManager;
    private final ProjectComponentManager componentManager;
    private final ProjectManager projectManager;

    public ComponentsLeadByUserFunction(PermissionManager permissionManager, ProjectComponentManager componentManager, ProjectManager projectManager, UserUtil userUtil) {
        super(userUtil);
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.componentManager = (ProjectComponentManager)Assertions.notNull((String)"componentManager", (Object)componentManager);
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.COMPONENT;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, ApplicationUser user) {
        Iterable<ProjectComponent> components = this.getLeadComponents(user);
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>();
        for (ProjectComponent component : components) {
            Project project = this.projectManager.getProjectObj(component.getProjectId());
            if (!queryCreationContext.isSecurityOverriden() && !this.permissionManager.hasPermission(10, project, queryCreationContext.getApplicationUser())) continue;
            values.add(new QueryLiteral((Operand)functionOperand, component.getId()));
        }
        return values;
    }

    private Iterable<ProjectComponent> getLeadComponents(ApplicationUser user) {
        return this.componentManager.findComponentsByLead(user.getName());
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_COMPONENT_NO_SUCH_USER;
    }
}

