/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issueview;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.issueview.IssueView;
import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParamsHelper;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParamsImpl;
import com.atlassian.jira.plugin.issueview.IssueViewURLHandler;
import com.atlassian.jira.plugin.searchrequestview.HttpRequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.Query;
import com.atlassian.seraph.util.RedirectUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultIssueViewURLHandler
implements IssueViewURLHandler {
    private final PluginAccessor pluginAccessor;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final SearchProvider searchProvider;
    private final IssueViewRequestParamsHelper issueViewRequestParamsHelper;
    private final CrowdService crowdService;

    public DefaultIssueViewURLHandler(PluginAccessor pluginAccessor, IssueManager issueManager, PermissionManager permissionManager, SearchProvider searchProvider, IssueViewRequestParamsHelper issueViewRequestParamsHelper, CrowdService crowdService) {
        this.pluginAccessor = pluginAccessor;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.searchProvider = searchProvider;
        this.issueViewRequestParamsHelper = issueViewRequestParamsHelper;
        this.crowdService = crowdService;
    }

    @Override
    public String getURLWithoutContextPath(IssueViewModuleDescriptor moduleDescriptor, String issueKey) {
        return "/si/" + moduleDescriptor.getCompleteKey() + "/" + issueKey + "/" + issueKey + "." + moduleDescriptor.getFileExtension();
    }

    private static String getSampleURL() {
        return "/si/jira.issueviews:xml/JRA-10/JRA-10.xml";
    }

    @Override
    @SuppressWarnings(value={"HRS_REQUEST_PARAMETER_TO_HTTP_HEADER"}, justification="JIRA has a HeaderSanitisingFilter that protects against this")
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Issue issue;
        int firstSlashLocation;
        String pathInfo = request.getPathInfo();
        if (StringUtils.isBlank((String)pathInfo)) {
            response.sendError(400, "Invalid path format. Path should be of format " + DefaultIssueViewURLHandler.getSampleURL());
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        if ((firstSlashLocation = pathInfo.indexOf("/")) == -1) {
            response.sendError(400, "Invalid path format. Path should be of format " + DefaultIssueViewURLHandler.getSampleURL());
            return;
        }
        String pluginKey = pathInfo.substring(0, firstSlashLocation);
        int secondSlashLocation = pathInfo.indexOf("/", firstSlashLocation + 1);
        if (secondSlashLocation == -1) {
            response.sendError(400, "Invalid path format. Path should be of format " + DefaultIssueViewURLHandler.getSampleURL());
            return;
        }
        String issueKey = pathInfo.substring(firstSlashLocation + 1, secondSlashLocation);
        User user = null;
        if (request.getRemoteUser() != null && (user = this.crowdService.getUser(request.getRemoteUser())) == null) {
            response.sendError(400, "Could not find a user with the username " + StringEscapeUtils.escapeHtml((String)request.getRemoteUser()));
            return;
        }
        IssueViewModuleDescriptor moduleDescriptor = this.getPluginModule(pluginKey);
        if (moduleDescriptor == null) {
            response.sendError(400, "Could not find any enabled plugin with key " + StringEscapeUtils.escapeHtml((String)pluginKey));
            return;
        }
        if ("index".equalsIgnoreCase(request.getParameter("jira.issue.searchlocation"))) {
            issue = this.getIssueFromIndex(issueKey, user);
        } else {
            issue = this.getIssueFromDatabase(issueKey);
            if (issue != null && !issue.getKey().equals(issueKey)) {
                String contextPath = request.getContextPath() != null ? request.getContextPath() : "";
                String queryString = request.getQueryString() != null ? '?' + request.getQueryString() : "";
                response.sendRedirect(contextPath + this.getURLWithoutContextPath(moduleDescriptor, issue.getKey()) + queryString);
                return;
            }
            if (issue != null && !this.permissionManager.hasPermission(10, issue, user)) {
                if (user == null) {
                    response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
                } else {
                    this.runJSP(request, response, "/secure/views/permissionviolation.jsp");
                }
                return;
            }
        }
        if (issue == null) {
            response.sendError(404, "Could not find issue with issue key " + StringEscapeUtils.escapeHtml((String)issueKey));
            return;
        }
        IssueView view = moduleDescriptor.getIssueView();
        IssueViewFieldParams issueViewFieldParams = this.issueViewRequestParamsHelper.getIssueViewFieldParams(request.getParameterMap());
        if (issueViewFieldParams.isCustomViewRequested() && !issueViewFieldParams.isAnyFieldDefined()) {
            response.sendError(400, "No valid field defined for issue custom view");
            return;
        }
        IssueViewRequestParamsImpl issueViewRequestParams = new IssueViewRequestParamsImpl(issueViewFieldParams);
        String content = view.getContent(issue, (IssueViewRequestParams)issueViewRequestParams);
        if (!"true".equalsIgnoreCase(request.getParameter("noResponseHeaders"))) {
            response.setContentType(moduleDescriptor.getContentType() + ";charset=" + ComponentAccessor.getApplicationProperties().getEncoding());
            view.writeHeaders(issue, (RequestHeaders)new HttpRequestHeaders(response), (IssueViewRequestParams)issueViewRequestParams);
        }
        response.getWriter().write(content);
    }

    private IssueViewModuleDescriptor getPluginModule(String pluginKey) {
        try {
            return (IssueViewModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(pluginKey);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void runJSP(HttpServletRequest request, HttpServletResponse response, String jspPath) throws IOException {
        try {
            request.getRequestDispatcher(jspPath).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not load java server page", e);
        }
    }

    private Issue getIssueFromDatabase(String issueKey) {
        return this.issueManager.getIssueObject(issueKey);
    }

    private Issue getIssueFromIndex(String issueKey, User user) {
        Query query = StringUtils.isNotBlank((String)issueKey) ? JqlQueryBuilder.newBuilder().where().issue(new String[]{issueKey}).buildQuery() : JqlQueryBuilder.newBuilder().buildQuery();
        try {
            SearchResults searchResults = this.searchProvider.search(query, user, PagerFilter.getUnlimitedFilter());
            if (searchResults.getTotal() > 1) {
                throw new IllegalStateException("More than one issue returned when searching index for issue key " + issueKey);
            }
            if (searchResults.getTotal() == 0) {
                return null;
            }
            return (Issue)searchResults.getIssues().iterator().next();
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }
}

