/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.jira.cluster.ClusterServicesRegistry;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.jira.plugin.ha.PluginEventType;

public class PluginMessageSender {
    private final MessageHandler messageHandler;
    private volatile boolean canSendMessages;

    public PluginMessageSender(ClusterServicesRegistry clusterServicesRegistry) {
        this.messageHandler = clusterServicesRegistry.getMessageHandler();
    }

    public void sendPluginModuleEnabledMessage(String completeKey) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_MODULE_ENABLED, completeKey));
    }

    public void sendPluginModuleDisabledMessage(String completeKey) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_MODULE_DISABLED, completeKey));
    }

    public void sendPluginEnabledMessage(String key) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_ENABLED, key));
    }

    public void sendPluginDisabledMessage(String key) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_DISABLED, key));
    }

    public void sendPluginUninstalledMessage(String key) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_UNINSTALLED, key));
    }

    public void sendPluginUpgradedMessage(String key) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_UPGRADED, key));
    }

    public void sendPluginInstalledMessage(String key) {
        this.sendPluginMessage(this.serializeAsString(PluginEventType.PLUGIN_INSTALLED, key));
    }

    public void activate() {
        this.canSendMessages = true;
    }

    public void passivate() {
        this.canSendMessages = false;
    }

    public void stop() {
        this.canSendMessages = false;
    }

    private String serializeAsString(PluginEventType pluginEventType, String pluginKey) {
        return (Object)((Object)pluginEventType) + "-" + pluginKey;
    }

    private void sendPluginMessage(String supplementalInfo) {
        if (this.canSendMessages) {
            Message message = Message.pluginMessage(supplementalInfo);
            this.messageHandler.sendMessage("ALL", message);
        }
    }
}

