/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.aboutpagepanel;

import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.license.thirdparty.BomParser;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.aboutpagepanel.AboutPagePanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutPagePanelModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<Void>
implements AboutPagePanelModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(AboutPagePanelModuleDescriptorImpl.class);
    private static final String LOCATION_KEY = "location";
    private static final String MODULE_KEY = "module-key";
    private static final String FUNCTION_KEY = "function";
    private final EncodingConfiguration encodingConfiguration;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;
    private final BomParser bomParser;
    private String introduction = "";
    private String licenses = "";
    private String conclusion = "";
    private String introductionModule = "";
    private String conclusionModule = "";

    public AboutPagePanelModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, EncodingConfiguration encodingConfiguration, SoyTemplateRendererProvider soyTemplateRendererProvider, BomParser bomParser) {
        super(authenticationContext, moduleFactory);
        this.encodingConfiguration = encodingConfiguration;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
        this.bomParser = bomParser;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element introduction = element.element("introduction");
        Element licenses = element.element("licenses");
        Element conclusion = element.element("conclusion");
        if (introduction == null && licenses == null && conclusion == null) {
            throw new PluginParseException("An introduction template, licenses file or conclusion template must be provided.");
        }
        if (introduction != null) {
            this.introduction = this.assertFunctionPresent(introduction, "Introduction");
            this.introductionModule = this.assertModuleKeyPresent(introduction, "Introduction");
        }
        if (licenses != null) {
            this.licenses = this.assertLocationPresent(licenses, "Licenses");
        }
        if (conclusion != null) {
            this.conclusion = this.assertFunctionPresent(conclusion, "Conclusion");
            this.conclusionModule = this.assertModuleKeyPresent(conclusion, "Conclusion");
        }
    }

    private String assertModuleKeyPresent(Element introduction, String field) {
        String location = introduction.attributeValue(MODULE_KEY);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)location)) {
            throw new PluginParseException(field + " module key must be specified");
        }
        return location;
    }

    private String assertLocationPresent(Element introduction, String field) {
        String location = introduction.attributeValue(LOCATION_KEY);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)location)) {
            throw new PluginParseException(field + " license file must be specified");
        }
        return location;
    }

    private String assertFunctionPresent(Element introduction, String field) {
        String location = introduction.attributeValue(FUNCTION_KEY);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)location)) {
            throw new PluginParseException(field + " function must be specified");
        }
        return location;
    }

    @Override
    public String getPluginSectionHtml() {
        PluginAndMaterials pluginAndMaterials = this.getPluginAndMaterials();
        if (pluginAndMaterials == null) {
            return "";
        }
        HashMap a = Maps.newHashMap();
        a.put("pluginEntry", pluginAndMaterials);
        try {
            return this.getSoyRenderer().render("jira.webresources:action-soy-templates", "JIRA.Templates.About.renderModule", (Map)a);
        }
        catch (SoyException e) {
            log.info("Problem rendering {}", (Object)pluginAndMaterials, (Object)e);
            return "";
        }
    }

    private PluginAndMaterials getPluginAndMaterials() {
        try {
            SoyTemplateRenderer soyTemplateRenderer = this.getSoyRenderer();
            ArrayList<Material> a = this.getMaterials(this.plugin);
            String introduction = this.generateIntroduction(soyTemplateRenderer);
            String conclusion = this.generateConclusion(soyTemplateRenderer);
            return new PluginAndMaterials(this.plugin.getName(), introduction, conclusion, a);
        }
        catch (RuntimeException e) {
            log.info("Could not load license information for " + this.plugin.getName() + " " + this.plugin.getKey(), (Throwable)e);
            return null;
        }
    }

    private ArrayList<Material> getMaterials(Plugin plugin) {
        Set<Material> materials = this.loadMaterials(plugin);
        ArrayList a = Lists.newArrayList();
        a.addAll(materials);
        Collections.sort(a);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Material> loadMaterials(Plugin plugin) {
        HashSet materials = Sets.newHashSet();
        if (!StringUtils.isEmpty((String)this.getLicensesLocation())) {
            ClassLoader classLoader = plugin.getClassLoader();
            InputStream resourceAsStream = classLoader.getResourceAsStream(this.getLicensesLocation());
            try {
                String bomContents = IOUtils.toString((InputStream)resourceAsStream, (String)this.encodingConfiguration.getEncoding());
                Iterables.addAll((Collection)materials, this.bomParser.extractLgplMaterials(bomContents));
            }
            catch (IOException e) {
                log.debug("Could not load detailed license information for " + plugin.getName() + " " + plugin.getKey() + " : " + this.getName() + " at " + this.getLicensesLocation(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)resourceAsStream);
            }
        }
        return materials;
    }

    @VisibleForTesting
    String generateIntroduction(SoyTemplateRenderer soyTemplateRenderer) {
        return this.introductionOk() ? this.renderItem(soyTemplateRenderer, this.introduction, this.getIntroductionModuleKey()) : "";
    }

    @VisibleForTesting
    String generateConclusion(SoyTemplateRenderer soyTemplateRenderer) {
        return this.conclusionOk() ? this.renderItem(soyTemplateRenderer, this.conclusion, this.getConclusionModuleKey()) : "";
    }

    private boolean introductionOk() {
        return !StringUtils.isEmpty((String)this.introduction) && !StringUtils.isEmpty((String)this.introductionModule);
    }

    private boolean conclusionOk() {
        return !StringUtils.isEmpty((String)this.conclusion) && !StringUtils.isEmpty((String)this.conclusionModule);
    }

    @VisibleForTesting
    String renderItem(SoyTemplateRenderer soyTemplateRenderer, String item, String itemModuleKey) {
        try {
            return soyTemplateRenderer.render(itemModuleKey, item, new HashMap());
        }
        catch (SoyException e) {
            log.info("Couldn't render 'about-license' for " + itemModuleKey + ". Continuing with other modules.", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.info("Couldn't render 'about-license' for " + itemModuleKey + ". Continuing with other modules.", (Throwable)e);
        }
        return "";
    }

    private SoyTemplateRenderer getSoyRenderer() {
        return this.soyTemplateRendererProvider.getRenderer();
    }

    public String getIntroductionModuleKey() {
        return this.introductionModule;
    }

    public String getLicensesLocation() {
        return this.licenses;
    }

    public String getConclusionModuleKey() {
        return this.conclusionModule;
    }

    public static final class Material
    implements Comparable<Material> {
        private final String libraryName;
        private final String mavenInfo;
        private final String license;
        private final String url;
        private final String artifactType;

        public Material(String libraryName, String mavenInfo, String license, String url, String artifactType) {
            this.libraryName = libraryName;
            this.mavenInfo = mavenInfo;
            this.license = license;
            this.url = url;
            this.artifactType = artifactType;
        }

        public String getLibraryName() {
            return this.libraryName == null ? "" : this.libraryName;
        }

        public String getMavenInfo() {
            return this.mavenInfo == null ? "" : this.mavenInfo;
        }

        public String getLicense() {
            return this.license == null ? "" : this.license;
        }

        public String getUrl() {
            return this.url == null ? "" : this.url;
        }

        public String getArtifactType() {
            return this.artifactType == null ? "" : this.artifactType;
        }

        public boolean isUrlAndGav() {
            return !StringUtils.isEmpty((String)this.mavenInfo) && !StringUtils.isEmpty((String)this.url);
        }

        public boolean isUrlNotGav() {
            return StringUtils.isEmpty((String)this.mavenInfo) && !StringUtils.isEmpty((String)this.url);
        }

        public boolean isGavNotUrl() {
            return !StringUtils.isEmpty((String)this.mavenInfo) && StringUtils.isEmpty((String)this.url);
        }

        public String toString() {
            return this.getLibraryName() + "," + this.getMavenInfo() + "," + this.getLicense() + "," + this.getUrl() + "," + this.getArtifactType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Material material = (Material)o;
            if (this.artifactType != null ? !this.artifactType.equals(material.artifactType) : material.artifactType != null) {
                return false;
            }
            if (this.libraryName != null ? !this.libraryName.equals(material.libraryName) : material.libraryName != null) {
                return false;
            }
            if (this.license != null ? !this.license.equals(material.license) : material.license != null) {
                return false;
            }
            if (this.mavenInfo != null ? !this.mavenInfo.equals(material.mavenInfo) : material.mavenInfo != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(material.url) : material.url != null);
        }

        public int hashCode() {
            int result = this.libraryName != null ? this.libraryName.hashCode() : 0;
            result = 31 * result + (this.mavenInfo != null ? this.mavenInfo.hashCode() : 0);
            result = 31 * result + (this.license != null ? this.license.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.artifactType != null ? this.artifactType.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(Material material) {
            int result = this.getLibraryName().compareTo(material.getLibraryName());
            if (result != 0) {
                return result;
            }
            result = this.getMavenInfo().compareTo(material.getMavenInfo());
            if (result != 0) {
                return result;
            }
            result = this.getLicense().compareTo(material.getLicense());
            if (result != 0) {
                return result;
            }
            result = this.getUrl().compareTo(material.getUrl());
            if (result != 0) {
                return result;
            }
            return this.getArtifactType().compareTo(material.getArtifactType());
        }
    }

    public static final class PluginAndMaterials
    implements Comparable<PluginAndMaterials> {
        private final String pluginName;
        private final String introduction;
        private final String conclusion;
        private final List<Material> materials;

        public PluginAndMaterials(String pluginName, String introduction, String conclusion, List<Material> materials) {
            this.pluginName = pluginName;
            this.introduction = introduction;
            this.conclusion = conclusion;
            this.materials = materials;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getIntroductionHtml() {
            return this.introduction;
        }

        public String getConclusionHtml() {
            return this.conclusion;
        }

        public List<Material> getMaterials() {
            return this.materials;
        }

        public boolean isEntries() {
            return this.materials != null && this.materials.size() > 0;
        }

        @Override
        public int compareTo(PluginAndMaterials pluginAndMaterials) {
            if (pluginAndMaterials == null) {
                return 1;
            }
            int compare = this.getPluginName().compareTo(pluginAndMaterials.getPluginName());
            if (compare != 0) {
                return compare;
            }
            compare = this.getIntroductionHtml().compareTo(pluginAndMaterials.getIntroductionHtml());
            if (compare != 0) {
                return compare;
            }
            compare = this.getConclusionHtml().compareTo(pluginAndMaterials.getConclusionHtml());
            if (compare != 0) {
                return compare;
            }
            return this.getMaterials().size() - pluginAndMaterials.getMaterials().size();
        }
    }
}

