/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.OfBizPluginPersistentStateStore;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@EventComponent
public class JiraPluginPersistentStateStore
implements PluginPersistentStateStore,
InitializingComponent {
    private final OfBizPluginPersistentStateStore ofBizPluginPersistentStateStore;
    private final ClusterManager clusterManager;
    private final ApplicationProperties applicationProperties;
    private volatile Cache cache;

    public JiraPluginPersistentStateStore(OfBizPluginPersistentStateStore ofBizPluginPersistentStateStore, ClusterManager clusterManager, ApplicationProperties applicationProperties) {
        this.ofBizPluginPersistentStateStore = ofBizPluginPersistentStateStore;
        this.clusterManager = clusterManager;
        this.applicationProperties = applicationProperties;
        this.reloadKeys();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        if (this.clusterManager.isActive()) {
            this.reloadKeys();
        }
    }

    private void reloadKeys() {
        this.cache = new Cache(this.ofBizPluginPersistentStateStore.getState());
    }

    public synchronized void save(PluginPersistentState state) {
        MapDifference differences = Maps.difference((Map)this.cache.getState().getMap(), (Map)state.getMap());
        if (!differences.areEqual()) {
            if (this.clusterManager.isActive()) {
                this.ofBizPluginPersistentStateStore.updateState(differences.entriesOnlyOnRight());
                this.ofBizPluginPersistentStateStore.deleteState(differences.entriesOnlyOnLeft());
                this.ofBizPluginPersistentStateStore.updateState(this.getUpdateMap(differences.entriesDiffering()));
                this.reloadKeys();
            } else {
                this.cache = new Cache(state.getMap());
            }
        }
    }

    private Map<String, Boolean> getUpdateMap(Map<String, MapDifference.ValueDifference<Boolean>> diffMap) {
        HashMap updates = Maps.newHashMap();
        for (Map.Entry<String, MapDifference.ValueDifference<Boolean>> entry : diffMap.entrySet()) {
            updates.put(entry.getKey(), entry.getValue().rightValue());
        }
        return updates;
    }

    public PluginPersistentState load() {
        return this.cache.getState();
    }

    @Override
    public void afterInstantiation() throws Exception {
        Collection stringsWithPrefix = this.applicationProperties.getStringsWithPrefix("jira.plugin.state-");
        if (stringsWithPrefix.size() > 0) {
            this.cache = new Cache(stringsWithPrefix);
        }
        this.stripDotsFromPluginKeys();
    }

    public void stripDotsFromPluginKeys() {
        Map<String, Boolean> stateWithDots = this.ofBizPluginPersistentStateStore.getStateFor(".");
        if (stateWithDots.isEmpty()) {
            return;
        }
        HashMap correctedState = Maps.newHashMapWithExpectedSize((int)stateWithDots.size());
        for (Map.Entry<String, Boolean> entry : stateWithDots.entrySet()) {
            correctedState.put(entry.getKey().substring(1), entry.getValue());
        }
        this.ofBizPluginPersistentStateStore.updateState(correctedState);
        this.ofBizPluginPersistentStateStore.deleteState(stateWithDots);
    }

    class Cache {
        private final PluginPersistentState state;

        Cache(Map<String, Boolean> stateMap) {
            this.state = this.buildState(stateMap);
        }

        private PluginPersistentState buildState(Map<String, Boolean> stateMap) {
            return PluginPersistentState.Builder.create().addState(stateMap).toState();
        }

        Cache(Collection<String> keys) {
            int statePrefixIndex = "jira.plugin.state-".length() + 1;
            HashMap stateMap = Maps.newHashMap();
            for (String key : keys) {
                stateMap.put(key.substring(statePrefixIndex), Boolean.valueOf(JiraPluginPersistentStateStore.this.applicationProperties.getString(key)));
            }
            this.state = this.buildState(stateMap);
        }

        public PluginPersistentState getState() {
            return this.state;
        }
    }
}

