/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSource;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class AbstractJiraModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements JiraResourcedModuleDescriptor<T> {
    private String descriptionKey;
    private String i18nNameKey;
    private final ResettableLazyReference<T> moduleReference = new ResettableLazyReference<T>(){

        protected T create() throws Exception {
            return AbstractJiraModuleDescriptor.this.createModule();
        }
    };
    private final JiraAuthenticationContext authenticationContext;
    private static final Logger log = Logger.getLogger(AbstractJiraModuleDescriptor.class);

    protected AbstractJiraModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(moduleFactory);
        this.authenticationContext = authenticationContext;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element descriptionEl = element.element("description");
        if (descriptionEl != null && descriptionEl.attribute("key") != null) {
            this.descriptionKey = descriptionEl.attributeValue("key");
        }
        this.i18nNameKey = element.attributeValue("i18n-name-key");
    }

    protected void assertResourceExists(String type, String name) throws PluginParseException {
        if (this.getResourceDescriptor(type, name) == null) {
            throw new PluginParseException("Resource with type: " + type + " and name " + name + " does not exist but should.");
        }
    }

    public String getHtml(String resourceName) {
        return this.getHtml(resourceName, new HashMap());
    }

    public String getHtml(String resourceName, Map<String, ?> startingParams) {
        try {
            StringWriter sw = new StringWriter();
            this.writeHtml(resourceName, startingParams, sw);
            return sw.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void writeHtml(String resourceName, Map<String, ?> startingParams, Writer writer) throws IOException {
        ResourceDescriptor resource = this.getResourceDescriptor("velocity", resourceName);
        if (resource == null) {
            return;
        }
        Map<String, Object> velocityParams = this.createVelocityParams(startingParams);
        if (StringUtils.isNotBlank((String)resource.getLocation())) {
            this.getTemplatingEngine().render(this.getTemplateSource(resource)).applying(velocityParams).asHtml(writer);
        } else {
            this.getTemplatingEngine().render(TemplateSources.fragment((String)resource.getContent())).applying(velocityParams).asHtml(writer);
        }
    }

    private TemplateSource getTemplateSource(ResourceDescriptor resource) {
        return TemplateSources.file((String)(this.getCompleteKey() + "/" + resource.getLocation()));
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    public T getModule() {
        return (T)this.moduleReference.get();
    }

    protected T createModule() {
        Object module = this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
        new GhettoInitter(module, (Object)this).maybeInit();
        return (T)module;
    }

    private VelocityRequestContextFactory getVelocityRequestContextFactory() {
        return (VelocityRequestContextFactory)ComponentAccessor.getComponentOfType(VelocityRequestContextFactory.class);
    }

    public String getDescription() {
        if (this.descriptionKey != null) {
            return this.getI18nBean().getText(this.descriptionKey);
        }
        return super.getDescription();
    }

    public String getName() {
        if (this.i18nNameKey != null) {
            return this.getI18nBean().getText(this.i18nNameKey);
        }
        return super.getName();
    }

    protected JiraAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    @Deprecated
    public String getText(String key) {
        return this.getI18nBean().getText(key);
    }

    public String getText(String key, Object params) {
        return this.getI18nBean().getText(key, params);
    }

    public I18nHelper getI18nBean() {
        return this.authenticationContext.getI18nHelper();
    }

    protected Map<String, Object> createVelocityParams(Map<String, Object> startingParams) {
        Map params = this.getVelocityRequestContextFactory().getDefaultVelocityParams(startingParams, this.authenticationContext);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!params.containsKey("i18n")) {
            result.put("i18n", this.getI18nBean());
        }
        if (!params.containsKey("ctx")) {
            result.put("ctx", params);
        }
        result.put("descriptor", (Object)this);
        return CompositeMap.of(result, (Map)params);
    }

    protected boolean isResourceExist(String resourceName) {
        return this.getResourceDescriptor("velocity", resourceName) != null;
    }

    protected ClassLoader getClassLoader() {
        return this.getPlugin().getClassLoader();
    }

    public void enabled() {
        super.enabled();
        this.moduleReference.reset();
    }

    public void disabled() {
        super.disabled();
        this.moduleReference.reset();
    }

    private class GhettoInitter {
        private final Object maybeNeedsInit;
        private final Object argumentForInit;

        public GhettoInitter(Object maybeNeedsInit, Object argumentForInit) {
            this.maybeNeedsInit = maybeNeedsInit;
            this.argumentForInit = argumentForInit;
        }

        public void maybeInit() {
            try {
                for (Method m : this.maybeNeedsInit.getClass().getMethods()) {
                    if (!m.getName().equals("init") || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(this.argumentForInit.getClass())) continue;
                    m.invoke(this.maybeNeedsInit, this.argumentForInit);
                    break;
                }
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("Unable to instantiate module class: " + this.maybeNeedsInit.getClass()), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("Unable to instantiate module class: " + this.maybeNeedsInit.getClass()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

