/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ProjectLead
extends AbstractNotificationType {
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectLead(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        ApplicationUser lead;
        Project project = event.getIssue().getProjectObject();
        String leadKey = project.getLeadUserKey();
        if (leadKey != null && (lead = ComponentAccessor.getUserManager().getUserByKey(leadKey)) != null) {
            return Arrays.asList(new NotificationRecipient(lead));
        }
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.project.lead");
    }
}

