/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.EventUtils;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CurrentAssignee
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(CurrentAssignee.class);
    private final ApplicationProperties applicationProperties;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CurrentAssignee(JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
    }

    boolean isPostJRA6344inPlay() {
        String value = this.applicationProperties.getDefaultBackedString("jira.assignee.change.is.sent.to.both.parties");
        if (StringUtils.isBlank((String)value)) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        List<Object> recipients;
        Issue issue = event.getIssue();
        if (issue != null) {
            recipients = this.isPostJRA6344inPlay() ? this.notificationStategyPostJRA6344(event, issue) : this.notificationStategyPreJRA6344(event, issue);
        } else {
            log.error((Object)("Error getting assignee notification recipients - no issue associated with event: " + event.getEventTypeId()));
            recipients = Collections.emptyList();
        }
        return recipients;
    }

    List<NotificationRecipient> notificationStategyPreJRA6344(IssueEvent event, Issue issue) {
        ArrayList<NotificationRecipient> recipients = new ArrayList<NotificationRecipient>();
        if (EventType.ISSUE_ASSIGNED_ID.equals(event.getEventTypeId())) {
            this.addPreviousAssignee(event, recipients);
        }
        this.addCurrentAssignee(issue, recipients);
        return recipients;
    }

    List<NotificationRecipient> notificationStategyPostJRA6344(IssueEvent event, Issue issue) {
        ArrayList<NotificationRecipient> recipients = new ArrayList<NotificationRecipient>();
        this.addPreviousAssignee(event, recipients);
        this.addCurrentAssignee(issue, recipients);
        return recipients;
    }

    private void addCurrentAssignee(Issue issue, List<NotificationRecipient> recipients) {
        UserManager userManager = ComponentAccessor.getUserManager();
        ApplicationUser u = userManager.getUserByKey(issue.getAssigneeId());
        if (u != null) {
            recipients.add(new NotificationRecipient(u));
        }
    }

    private void addPreviousAssignee(IssueEvent event, List<NotificationRecipient> recipients) {
        ApplicationUser previousAssignee = this.getPreviousAssignee(event);
        if (previousAssignee != null) {
            recipients.add(new NotificationRecipient(previousAssignee));
        }
    }

    protected ApplicationUser getPreviousAssignee(IssueEvent event) {
        return EventUtils.getPreviousAssignee(event);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.current.assignee");
    }
}

