/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.mail.util.ByteArrayDataSource;
import com.atlassian.jira.mail.util.MailAttachmentManager;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.NotNull;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class MailAttachmentManagerImpl
implements MailAttachmentManager {
    private AvatarManager manager;
    private Map<String, Avatar> avatars = Maps.newHashMap();

    public MailAttachmentManagerImpl(AvatarManager manager) {
        this.manager = manager;
    }

    @Override
    public void addAvatar(Avatar avatar, String attachmentId) {
        if (avatar == null || StringUtils.isBlank((String)attachmentId)) {
            return;
        }
        this.avatars.put(attachmentId, avatar);
    }

    @Override
    public boolean haveAnyAttachments() {
        return this.avatars.size() > 0;
    }

    @Override
    public Collection<BodyPart> buildAsBodyParts() throws IOException, MessagingException {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, Avatar> entry : this.avatars.entrySet()) {
            Avatar avatar = entry.getValue();
            ByteArrayDataSource avatarDataSource = new ByteArrayDataSource(new ByteArrayInputStream(this.getAvatarAsBytes(avatar)), avatar.getContentType());
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setDataHandler(new DataHandler((DataSource)avatarDataSource));
            bodyPart.setHeader("Content-ID", String.format("<%s>", entry.getKey()));
            result.add(bodyPart);
        }
        return result;
    }

    private byte[] getAvatarAsBytes(Avatar avatar) throws IOException {
        ToByteArrayConsumer toByteArrayConsumer = new ToByteArrayConsumer();
        this.manager.readAvatarData(avatar, AvatarManager.ImageSize.defaultSize(), (Consumer)toByteArrayConsumer);
        return toByteArrayConsumer.getBytes();
    }

    private static class ToByteArrayConsumer
    implements Consumer<InputStream> {
        private byte[] bytes;

        private ToByteArrayConsumer() {
        }

        public void consume(@NotNull InputStream element) {
            try {
                this.bytes = IOUtils.toByteArray((InputStream)element);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

