/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.CommentVisibility;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.mail.DefaultTemplateContext;
import com.atlassian.jira.mail.DiffUtils;
import com.atlassian.jira.mail.TemplateIssueFactory;
import com.atlassian.jira.mail.TemplateUser;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.web.action.util.DiffViewRenderer;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class IssueTemplateContext
extends DefaultTemplateContext {
    private static final Logger log = Logger.getLogger(IssueTemplateContext.class);
    private static final Integer PADSIZE = 20;
    private final IssueEvent issueEvent;
    private final JiraDurationUtils jiraDurationUtils;
    private final Issue issue;
    private final TemplateIssueFactory templateIssueFactory;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final EventTypeManager eventTypeManager;
    private final DiffViewRenderer diffViewRenderer;
    private final UserManager userManager;

    public IssueTemplateContext(Locale locale, IssueEvent issueEvent, TemplateIssueFactory templateIssueFactory, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, UserManager userManager, JiraDurationUtils jiraDurationUtils, EventTypeManager eventTypeManager, DiffViewRenderer diffViewRenderer, WebResourceManager resourceManager, ApplicationProperties applicationProperties, I18nHelper.BeanFactory beanFactory) {
        super(locale, resourceManager, applicationProperties, beanFactory);
        this.issueEvent = issueEvent;
        this.jiraDurationUtils = jiraDurationUtils;
        this.issue = issueEvent.getIssue();
        this.templateIssueFactory = templateIssueFactory;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.eventTypeManager = eventTypeManager;
        this.userManager = userManager;
        this.diffViewRenderer = diffViewRenderer;
    }

    @Override
    public Map<String, Object> getTemplateParams() {
        Map<String, Object> templateParams = super.getTemplateParams();
        templateParams.put("context", this);
        templateParams.put("issue", this.templateIssueFactory.getTemplateIssue(this.issue));
        templateParams.put("params", this.issueEvent.getParams());
        templateParams.put("remoteUser", TemplateUser.getUser(this.issueEvent.getUser()));
        templateParams.putAll(this.getUtilParams());
        templateParams.putAll(this.getAttachmentParams());
        templateParams.putAll(this.getCommentParams());
        templateParams.putAll(this.getOriginalCommentParams());
        templateParams.putAll(this.getWorkLogParams());
        templateParams.putAll(this.getChangeLogParams());
        templateParams.putAll(this.getDiffParams());
        templateParams.put("security", this.issue.getSecurityLevel());
        templateParams.put("rendererManager", this.rendererManager);
        return templateParams;
    }

    private Map<String, Object> getDiffParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("diffutils", new DiffUtils(this.diffViewRenderer));
        return params;
    }

    private Map<String, Object> getOriginalCommentParams() {
        HashMap<String, Object> originalCommentParams = new HashMap<String, Object>();
        Comment originalComment = (Comment)this.issueEvent.getParams().get("originalcomment");
        if (originalComment != null) {
            try {
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeObject().getId()).getFieldLayoutItem("comment");
                String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
                originalCommentParams.put("originalhtmlComment", this.rendererManager.getRenderedContent(rendererType, originalComment.getBody(), this.issue.getIssueRenderContext()));
            }
            catch (Exception e) {
                log.warn((Object)("Unable to produce rendered version of the comment for the issue " + this.issue.getKey() + "."), (Throwable)e);
                originalCommentParams.put("originalhtmlComment", JiraKeyUtils.linkBugKeys((String)originalComment.getBody()));
            }
            originalCommentParams.put("originalcomment", originalComment);
            ApplicationUser author = originalComment.getAuthorApplicationUser();
            originalCommentParams.put("originalcommentauthor", author);
            if (originalComment.getGroupLevel() == null) {
                ProjectRole role = originalComment.getRoleLevel();
                if (role != null) {
                    originalCommentParams.put("originalroleVisibilityLevel", role.getName());
                }
            } else {
                originalCommentParams.put("originalgroupVisibilityLevel", originalComment.getGroupLevel());
            }
        }
        return originalCommentParams;
    }

    public Map<String, Object> getUtilParams() {
        HashMap<String, Object> utilParams = new HashMap<String, Object>();
        utilParams.put("stringUtils", new StringUtils());
        utilParams.put("padSize", PADSIZE);
        utilParams.put("timeSpentFieldId", "timespent");
        return utilParams;
    }

    public Map<String, Object> getAttachmentParams() {
        HashMap<String, Object> attachmentParams = new HashMap<String, Object>();
        attachmentParams.put("attachments", this.issue.getAttachments());
        return attachmentParams;
    }

    public Map<String, Object> getCommentParams() {
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        Comment comment = this.issueEvent.getComment();
        if (comment != null) {
            try {
                FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeObject().getId()).getFieldLayoutItem("comment");
                String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
                commentParams.put("htmlComment", this.rendererManager.getRenderedContent(rendererType, comment.getBody(), this.issue.getIssueRenderContext()));
            }
            catch (Exception e) {
                log.warn((Object)("Unable to produce rendered version of the comment for the issue " + this.issue.getKey() + "."), (Throwable)e);
                commentParams.put("htmlComment", JiraKeyUtils.linkBugKeys((String)comment.getBody()));
            }
            commentParams.put("comment", comment);
            commentParams.put("commentauthor", comment.getAuthorApplicationUser());
            if (comment.getGroupLevel() == null) {
                ProjectRole role = comment.getRoleLevel();
                if (role != null) {
                    commentParams.put("roleVisibilityLevel", role.getName());
                }
            } else {
                commentParams.put("groupVisibilityLevel", comment.getGroupLevel());
            }
        }
        return commentParams;
    }

    private Map<String, Object> getWorkLogParams() {
        HashMap<String, Object> workLogParams = new HashMap<String, Object>();
        Worklog worklog = this.issueEvent.getWorklog();
        if (worklog != null) {
            workLogParams.put("worklog", worklog);
            String worklogComment = worklog.getComment();
            if (worklogComment != null) {
                String worklogCommentHtml = this.rendererManager.getRenderedContent("atlassian-wiki-renderer", worklogComment, this.issue.getIssueRenderContext());
                workLogParams.put("worklogCommentHtml", worklogCommentHtml);
            }
            if (worklog.getGroupLevel() == null) {
                ProjectRole role = worklog.getRoleLevel();
                if (role != null) {
                    workLogParams.put("roleVisibilityLevel", role.getName());
                }
            } else {
                workLogParams.put("groupVisibilityLevel", worklog.getGroupLevel());
            }
            Worklog originalWorklog = (Worklog)this.issueEvent.getParams().get("originalworklog");
            if (originalWorklog != null) {
                if (originalWorklog.getGroupLevel() == null) {
                    ProjectRole role = originalWorklog.getRoleLevel();
                    if (role != null) {
                        workLogParams.put("originalroleVisibilityLevel", role.getName());
                    }
                } else {
                    workLogParams.put("originalgroupVisibilityLevel", originalWorklog.getGroupLevel());
                }
                if (!worklog.getTimeSpent().equals(originalWorklog.getTimeSpent())) {
                    workLogParams.put("timeSpentUpdated", Boolean.TRUE);
                }
                if (!worklog.getStartDate().equals(originalWorklog.getStartDate())) {
                    workLogParams.put("startDateUpdated", Boolean.TRUE);
                }
                if (!StringUtils.equals((String)originalWorklog.getComment(), (String)worklog.getComment())) {
                    workLogParams.put("commentUpdated", Boolean.TRUE);
                }
                if (this.worklogVisibilityUpdated(originalWorklog, worklog)) {
                    workLogParams.put("visibilityUpdated", Boolean.TRUE);
                }
                workLogParams.put("originalworklog", originalWorklog);
            }
        }
        return workLogParams;
    }

    private boolean worklogVisibilityUpdated(Worklog originalWorklog, Worklog worklog) {
        String newVisibility;
        String originalVisibility = CommentVisibility.getCommentLevelFromLevels(originalWorklog.getGroupLevel(), originalWorklog.getRoleLevelId());
        return !StringUtils.equals((String)originalVisibility, (String)(newVisibility = CommentVisibility.getCommentLevelFromLevels(worklog.getGroupLevel(), worklog.getRoleLevelId())));
    }

    public String getCommentTimeLogged(I18nHelper i18n) {
        Worklog worklog = this.issueEvent.getWorklog();
        return this.getTimeLogged(worklog, i18n);
    }

    public String getTimeLogged(Worklog worklog, I18nHelper i18n) {
        if (worklog != null && worklog.getTimeSpent() != null) {
            return this.jiraDurationUtils.getFormattedDuration(worklog.getTimeSpent(), i18n.getLocale());
        }
        return null;
    }

    public String getEventTypeName(I18nHelper i18n) {
        String i18nValue;
        EventType eventType = this.eventTypeManager.getEventType(this.issueEvent.getEventTypeId());
        String emailEventKey = "email." + eventType.getNameKey();
        if (emailEventKey.equals(i18nValue = i18n.getText(emailEventKey))) {
            return eventType.getName();
        }
        return i18nValue;
    }

    public Map<String, Object> getChangeLogParams() {
        HashMap<String, Object> commentParams = new HashMap<String, Object>();
        GenericValue changelog = this.issueEvent.getChangeLog();
        if (changelog != null) {
            commentParams.put("changelog", changelog);
            commentParams.put("changelogauthor", this.userManager.getUserByKeyEvenWhenUnknown(changelog.getString("author")));
        }
        return commentParams;
    }
}

