/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import com.atlassian.jira.mail.CssInliner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;

public class BotoCssInliner
implements CssInliner {
    private final ReentrantLock styleCreationLock = new ReentrantLock();
    private WeakReference<BotocssStyles> botocssStyles;
    private final List<String> cssFilenames = ImmutableList.builder().add((Object)"templates/email/css/aui-styles.css").add((Object)"templates/email/css/all-clients.css").add((Object)"templates/email/css/wiki-renderer.css").add((Object)"templates/email/css/jira-styles.css").build();

    public BotoCssInliner() {
        this.botocssStyles = new WeakReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BotocssStyles getBotocssStyles() {
        try {
            this.styleCreationLock.lock();
            BotocssStyles styles = (BotocssStyles)this.botocssStyles.get();
            if (styles == null) {
                styles = this.createStyles();
                this.botocssStyles = new WeakReference<BotocssStyles>(styles);
            }
            BotocssStyles botocssStyles = styles;
            return botocssStyles;
        }
        finally {
            this.styleCreationLock.unlock();
        }
    }

    private BotocssStyles createStyles() {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream stream = null;
        for (String filename : this.cssFilenames) {
            try {
                stream = (InputStream)Preconditions.checkNotNull((Object)this.getClass().getClassLoader().getResourceAsStream(filename));
                stringBuilder.append(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        BotocssStyles styles = BotocssStyles.parse((String[])new String[]{stringBuilder.toString()});
        return styles;
    }

    @Override
    public String applyStyles(String html) {
        if (html == null) {
            return null;
        }
        return Botocss.inject((String)html, (BotocssStyles)this.getBotocssStyles());
    }
}

