/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.google.common.base.Strings;

public class DefaultOnDemandLicenseDetails
extends DefaultLicenseDetails {
    DefaultOnDemandLicenseDetails(JiraLicense license, String licenseString, ApplicationProperties applicationProperties, ExternalLinkUtil externalLinkUtil, BuildUtilsInfo buildUtilsInfo, I18nHelper.BeanFactory i18nFactory, DateTimeFormatter dateTimeFormatter) {
        super(license, licenseString, applicationProperties, externalLinkUtil, buildUtilsInfo, i18nFactory, dateTimeFormatter);
    }

    @Override
    public boolean isEvaluation() {
        return !Strings.isNullOrEmpty((String)this.license.getProperty("jira.TrialEndDate"));
    }

    @Override
    public int getMaximumNumberOfUsers() {
        String numHostedUsers = this.license.getProperty("jira.numHostedUsers");
        try {
            return Integer.parseInt(numHostedUsers);
        }
        catch (NumberFormatException ex) {
            return super.getMaximumNumberOfUsers();
        }
    }

    @Override
    public boolean isUnlimitedNumberOfUsers() {
        return this.getMaximumNumberOfUsers() == -1;
    }

    @Override
    public boolean isOnDemand() {
        return true;
    }
}

