/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.LicenseDetails;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultLicenseStatusMessage
implements LicenseDetails.LicenseStatusMessage {
    private final List<String> messagesOrder;
    private final Map<String, String> messages;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultLicenseStatusMessage(List<String> messagesOrder, Map<String, String> messages) {
        this.messagesOrder = messagesOrder;
        this.messages = messages;
    }

    public String getAllMessages(String delimiter) {
        Iterable values = Iterables.transform(this.messagesOrder, (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return (String)DefaultLicenseStatusMessage.this.messages.get(input);
            }
        });
        return Joiner.on((String)delimiter).join(values);
    }

    public Map<String, String> getAllMessages() {
        return this.messages;
    }

    public boolean hasMessageOfType(String messageKey) {
        return this.messages.containsKey(messageKey);
    }

    public static class Builder {
        private ImmutableMap.Builder<String, String> values = new ImmutableMap.Builder();
        private ImmutableList.Builder<String> keys = new ImmutableList.Builder();

        public DefaultLicenseStatusMessage build() {
            return new DefaultLicenseStatusMessage((List<String>)this.keys.build(), (Map<String, String>)this.values.build());
        }

        protected Builder add(String key, String message) {
            this.values.put((Object)key, (Object)message);
            this.keys.add((Object)key);
            return this;
        }
    }
}

