/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class RelationalOperatorMutatedIndexValueQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(RelationalOperatorMutatedIndexValueQueryFactory.class);
    private final IndexInfoResolver<?> indexInfoResolver;
    private final RangeQueryFactory<String> rangeQueryFactory = RangeQueryFactory.stringRangeQueryFactory();

    public RelationalOperatorMutatedIndexValueQueryFactory(IndexInfoResolver<?> indexInfoResolver) {
        this.indexInfoResolver = indexInfoResolver;
    }

    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug((Object)String.format("Integer operands do not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<String> mutatedValues = this.getIndexValues(rawValues);
        if (mutatedValues.isEmpty() || mutatedValues.get(0) == null) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult(this.rangeQueryFactory.get(operator, fieldName, (Object)mutatedValues.get(0)));
    }

    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug((Object)"Empty operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug((Object)"Multi value operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }

    List<String> getIndexValues(List<QueryLiteral> rawValues) {
        if (rawValues == null || rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> indexValues = new ArrayList<String>();
        for (QueryLiteral rawValue : rawValues) {
            List vals;
            if (rawValue == null) continue;
            if (rawValue.getStringValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getStringValue());
            } else if (rawValue.getLongValue() != null) {
                vals = this.indexInfoResolver.getIndexedValues(rawValue.getLongValue());
            } else {
                indexValues.add(null);
                continue;
            }
            if (vals == null || vals.isEmpty()) continue;
            indexValues.addAll(vals);
        }
        return indexValues;
    }
}

