/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.util.Function;
import com.atlassian.query.operator.Operator;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DateRelationalQueryFactory
extends AbstractDateOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(DateRelationalQueryFactory.class);
    private final RangeQueryFactory<Date> rangeQueryFactory;

    public DateRelationalQueryFactory(final JqlDateSupport jqlDateSupport) {
        super(jqlDateSupport);
        this.rangeQueryFactory = new RangeQueryFactory((Function)new Function<Date, String>(){

            public String get(Date date) {
                return jqlDateSupport.getIndexedValue(date);
            }
        });
    }

    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug((Object)String.format("Date operands do not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<Date> dates = this.getDateValues(rawValues);
        if (dates.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        Date value = dates.get(0);
        if (value == null) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult(this.rangeQueryFactory.get(operator, fieldName, (Object)value));
    }

    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug((Object)"Multi value operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug((Object)"Empty operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }
}

