/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.webwork.JiraActionFactory;
import com.atlassian.jira.jelly.ActionTagSupport;
import com.atlassian.jira.jelly.JellyHttpRequest;
import com.atlassian.jira.jelly.JellyHttpResponse;
import com.atlassian.jira.security.login.JiraSeraphAuthenticator;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.seraph.auth.AuthenticatorException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import webwork.action.Action;
import webwork.action.ActionSupport;
import webwork.action.factory.ActionFactory;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.GenericDispatcher;
import webwork.util.ValueStack;

public class WebWorkAdaptor {
    private static final Logger log = Logger.getLogger(WebWorkAdaptor.class);
    private static final String STACK_HEAD = "webwork.valuestack.head";
    private static final boolean FAILURE = false;
    private static final boolean SUCCESS = true;
    private HashMap jellyHttpSession = new HashMap();
    private JellyHttpResponse jellyHttpResponse;
    private JellyHttpRequest jellyHttpRequest = new JellyHttpRequest(this.jellyHttpSession);
    private ActionResult actionResult;

    public WebWorkAdaptor() {
        this.jellyHttpResponse = new JellyHttpResponse();
        Introspector.flushCaches();
        ValueStack.clearMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapJellyTagToAction(ActionTagSupport tag, XMLOutput output) throws JellyTagException {
        log.debug((Object)"WebWorkAdaptor.mapJellyTagToAction");
        InternalWebSudoManager internalWebSudoManager = (InternalWebSudoManager)ComponentAccessor.getComponent(InternalWebSudoManager.class);
        String actionName = tag.getActionName();
        this.jellyHttpRequest.getParameterMap().putAll(tag.getProperties());
        internalWebSudoManager.startSession(this.jellyHttpRequest, this.jellyHttpResponse);
        try {
            this.setSecurityCredentials(tag, output);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
        GenericDispatcher gd = new GenericDispatcher(actionName, ActionFactoryInstance.get());
        gd.prepareContext();
        gd.prepareValueStack();
        ActionContextKit.setContext((HttpServletRequest)this.jellyHttpRequest, (HttpServletResponse)this.jellyHttpResponse, actionName);
        try {
            gd.executeAction();
            this.setResult(gd.finish());
        }
        catch (Exception e) {
            boolean bl = this.processWebworkException(actionName, e, output, tag);
            return bl;
        }
        finally {
            gd.finalizeContext();
        }
        return this.processResult(tag, output);
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="TODO this needs to be fixed")
    protected boolean processResult(ActionTagSupport tag, XMLOutput output) throws JellyTagException {
        if (this.actionResult != null && this.actionResult.getActionException() != null) {
            log.error((Object)"Could not execute action", (Throwable)this.actionResult.getActionException());
            this.actionResult.getActionException().getMessage();
            StringBuffer errorMsg = new StringBuffer("Could not execute action [" + tag.getActionName() + "]:");
            errorMsg.append(this.actionResult.getActionException().getMessage());
            errorMsg.append("\n");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            this.actionResult.getActionException().printStackTrace(ps);
            errorMsg.append(baos.toString());
            errorMsg.append("\n");
            try {
                WebWorkAdaptor.writeErrorToXmlOutput(output, errorMsg, tag.getActionName(), (TagSupport)tag);
            }
            catch (SAXException e1) {
                log.error((Object)e1);
                throw new JellyTagException((Throwable)e1);
            }
            return false;
        }
        String result = this.actionResult.getResult();
        Action action = this.actionResult.getFirstAction();
        this.jellyHttpRequest.setAttribute(STACK_HEAD, action);
        boolean hasErrorMessages = false;
        boolean hasErrors = false;
        boolean hasSecurityErrors = false;
        try {
            StringBuffer buff;
            hasErrorMessages = ((ActionSupport)action).getHasErrorMessages();
            if (hasErrorMessages) {
                Collection errorMessages = ((ActionSupport)action).getErrorMessages();
                buff = new StringBuffer();
                buff.append("\nResult=").append(result).append("\n");
                for (Object errorMessage : errorMessages) {
                    String errorMsg = (String)errorMessage;
                    buff.append(errorMsg).append("\n");
                }
                WebWorkAdaptor.writeErrorToXmlOutput(output, buff, tag.getActionName(), (TagSupport)tag);
            }
            if (hasErrors = ((ActionSupport)action).getHasErrors()) {
                Map errors = ((ActionSupport)action).getErrors();
                buff = new StringBuffer();
                buff.append("\nResult=").append(result).append("\n");
                for (Object o : errors.keySet()) {
                    String fieldName = (String)o;
                    String errorMessage = (String)errors.get(fieldName);
                    buff.append("Error for field \"").append(fieldName).append("\"").append(" : ").append(errorMessage).append("\n");
                }
                WebWorkAdaptor.writeErrorToXmlOutput(output, buff, tag.getActionName(), (TagSupport)tag);
            }
            hasSecurityErrors = false;
            if (result.equalsIgnoreCase("securitybreach")) {
                hasSecurityErrors = true;
                StringBuffer buff2 = new StringBuffer("Security Breach");
                WebWorkAdaptor.writeErrorToXmlOutput(output, buff2, tag.getActionName(), (TagSupport)tag);
            }
        }
        catch (SAXException e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
        return !hasErrorMessages && !hasErrors && !hasSecurityErrors;
    }

    protected boolean processWebworkException(String actionName, Exception e, XMLOutput output, ActionTagSupport tag) throws JellyTagException {
        log.error((Object)("Could not execute action [" + actionName + "]:"), (Throwable)e);
        StringBuffer errorMsg = new StringBuffer("Could not execute action [" + actionName + "]:");
        errorMsg.append(e.getMessage());
        errorMsg.append("\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        errorMsg.append(baos.toString());
        errorMsg.append("\n");
        try {
            WebWorkAdaptor.writeErrorToXmlOutput(output, errorMsg, actionName, (TagSupport)tag);
        }
        catch (SAXException e1) {
            log.error((Object)e1);
            throw new JellyTagException((Throwable)e1);
        }
        return false;
    }

    private void setSecurityCredentials(ActionTagSupport tag, XMLOutput output) throws Exception {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponent(CrowdService.class);
        String userName = (String)tag.getContext().getVariable("jelly.username");
        String password = (String)tag.getContext().getVariable("jelly.password");
        if (userName != null) {
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByName(userName);
            if (user != null) {
                if (password != null) {
                    try {
                        crowdService.authenticate(user.getUsername(), password);
                        this.getJellyHttpSession().put("seraph_defaultauthenticator_user", user);
                        this.jellyHttpRequest.setUserPrincipal((Principal)user);
                    }
                    catch (FailedAuthenticationException e) {
                        log.info((Object)("Cannot login user '" + userName + "' as the password was incorrect"));
                    }
                } else {
                    this.getJellyHttpSession().put("seraph_defaultauthenticator_user", user);
                    this.jellyHttpRequest.setUserPrincipal((Principal)user);
                }
            } else {
                StringBuffer errorMsg = new StringBuffer("Security Error : User \"" + userName + "\" does not exist");
                WebWorkAdaptor.writeErrorToXmlOutput(output, errorMsg, tag.getActionName(), (TagSupport)tag);
            }
        } else {
            throw new IllegalStateException("JellyWebwork Security Error : No security credentials found in tag : " + tag.getActionName());
        }
    }

    public static void writeErrorToXmlOutput(XMLOutput output, StringBuffer errorMessage, String actionName, TagSupport badTag) throws SAXException {
        log.debug((Object)"WebWorkAdaptor.writeErrorToXmlOutput");
        AttributesImpl tagAttributes = new AttributesImpl();
        tagAttributes.addAttribute("", "", "action", "string", actionName);
        output.startElement("Error", (Attributes)tagAttributes);
        output.startElement("TagContents", (Attributes)new AttributesImpl());
        output.write(badTag.toString());
        output.endElement("TagContents");
        output.startElement("ExecutedAs", (Attributes)new AttributesImpl());
        output.write("user=" + badTag.getContext().getVariable("jelly.username"));
        output.endElement("ExecutedAs");
        output.startElement("ErrorMessage", (Attributes)new AttributesImpl());
        output.write(errorMessage.toString());
        output.endElement("ErrorMessage");
        output.endElement("Error");
    }

    public boolean authenticateUser(ActionTagSupport tag, String username, String password, XMLOutput output) throws Exception {
        try {
            ActionContextKit.setContext((HttpServletRequest)this.getJellyHttpRequest(), (HttpServletResponse)this.getJellyHttpResponse(), "Login");
            JiraSeraphAuthenticator authenticator = new JiraSeraphAuthenticator();
            return authenticator.login(this.getJellyHttpRequest(), this.getJellyHttpResponse(), username, password);
        }
        catch (AuthenticatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            WebWorkAdaptor.writeErrorToXmlOutput(output, new StringBuffer(e.getMessage()), tag.getActionName(), (TagSupport)tag);
            return false;
        }
    }

    public HashMap getJellyHttpSession() {
        return this.jellyHttpSession;
    }

    public JellyHttpResponse getJellyHttpResponse() {
        return this.jellyHttpResponse;
    }

    public JellyHttpRequest getJellyHttpRequest() {
        return this.jellyHttpRequest;
    }

    public void setResult(ActionResult actionResult) {
        this.actionResult = actionResult;
    }

    public ActionResult getResult() {
        return this.actionResult;
    }

    private static class ActionFactoryInstance {
        private static final ActionFactory INSTANCE = new JiraActionFactory.NonWebActionFactory();

        private ActionFactoryInstance() {
        }

        public static ActionFactory get() {
            return INSTANCE;
        }
    }
}

