/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.entity.EntityPagedList;
import com.atlassian.jira.entity.WorklogEntityFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.TimeTrackingIssueUpdater;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.issue.worklog.WorklogStore;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.collect.PagedList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;

public class DefaultWorklogManager
implements WorklogManager {
    private ProjectRoleManager projectRoleManager;
    private final WorklogStore worklogStore;
    private final TimeTrackingIssueUpdater timeTrackingIssueUpdater;

    public DefaultWorklogManager(ProjectRoleManager projectRoleManager, WorklogStore worklogStore, TimeTrackingIssueUpdater timeTrackingIssueUpdater) {
        this.projectRoleManager = projectRoleManager;
        this.worklogStore = worklogStore;
        this.timeTrackingIssueUpdater = timeTrackingIssueUpdater;
    }

    public boolean delete(User user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, false);
        this.timeTrackingIssueUpdater.updateIssueOnWorklogDelete(user, worklog, newEstimate, dispatchEvent);
        return this.worklogStore.delete(worklog.getId());
    }

    public Worklog create(User user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, true);
        Worklog newWorklog = this.worklogStore.create(worklog);
        this.timeTrackingIssueUpdater.updateIssueOnWorklogCreate(user, newWorklog, newEstimate, dispatchEvent);
        return newWorklog;
    }

    public Worklog update(User user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, false);
        Worklog originalWorklog = this.getById(worklog.getId());
        if (originalWorklog == null) {
            throw new IllegalArgumentException("Unable to find a worklog in the datastore for the provided id: '" + worklog.getId() + "'");
        }
        Long originalTimeSpent = originalWorklog.getTimeSpent();
        Worklog newWorklog = this.worklogStore.update(worklog);
        this.timeTrackingIssueUpdater.updateIssueOnWorklogUpdate(user, originalWorklog, newWorklog, originalTimeSpent, newEstimate, dispatchEvent);
        return newWorklog;
    }

    public Worklog getById(Long id) {
        return this.worklogStore.getById(id);
    }

    public List<Worklog> getByIssue(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Cannot resolve worklogs for null issue.");
        }
        return this.worklogStore.getByIssue(issue);
    }

    public PagedList<Worklog> getByIssue(Issue issue, int pageSize) {
        WorklogEntityFactory worklogEntityFactory = new WorklogEntityFactory(issue);
        EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), EntityOperator.EQUALS);
        ArrayList orderBy = Lists.newArrayList((Object[])new String[]{"created"});
        return new EntityPagedList<Worklog>(pageSize, worklogEntityFactory, (EntityCondition)condition, orderBy);
    }

    public int swapWorklogGroupRestriction(String groupName, String swapGroup) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        if (swapGroup == null) {
            throw new IllegalArgumentException("You must provide a non null swap group name.");
        }
        return this.worklogStore.swapWorklogGroupRestriction(groupName, swapGroup);
    }

    public long getCountForWorklogsRestrictedByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        return this.worklogStore.getCountForWorklogsRestrictedByGroup(groupName);
    }

    public ProjectRole getProjectRole(Long projectRoleId) {
        return this.projectRoleManager.getProjectRole(projectRoleId);
    }

    void validateWorklog(Worklog worklog, boolean create) {
        if (worklog == null) {
            throw new IllegalArgumentException("Worklog must not be null.");
        }
        if (worklog.getIssue() == null) {
            throw new IllegalArgumentException("The worklogs issue must not be null.");
        }
        if (!create && worklog.getId() == null) {
            throw new IllegalArgumentException("Can not modify a worklog with a null id.");
        }
    }
}

