/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.subscription;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.subscription.SendFilterJob;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueItem;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class DefaultSubscriptionManager
extends MailingListCompiler
implements SubscriptionManager {
    private static final Logger log = Logger.getLogger(DefaultSubscriptionManager.class);
    public static final String SUBSCRIPTION_PREFIX = "SUBSCRIPTION_";
    public static final String SUBSCRIPTION_IDENTIFIER = "SEND_SUBSCRIPTION";
    private static final String ENTITY_NAME = "FilterSubscription";
    private static final String ID = "id";
    private static final String USERKEY = "username";
    private static final String FILTER_ID = "filterID";
    private static final String GROUP = "group";
    private static final String LAST_RUN = "lastRun";
    private static final String EMAIL_ON_EMPTY = "emailOnEmpty";
    private final OfBizDelegator delegator;
    private final MailQueue mailQueue;
    private final SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory;
    private final GroupManager groupManager;

    public DefaultSubscriptionManager(OfBizDelegator delegator, MailQueue mailQueue, TemplateManager templateManager, SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory, ProjectRoleManager projectRoleManager, GroupManager groupManager) {
        super(templateManager, projectRoleManager);
        this.delegator = delegator;
        this.mailQueue = mailQueue;
        this.subscriptionMailQueueItemFactory = subscriptionMailQueueItemFactory;
        this.groupManager = groupManager;
    }

    public boolean hasSubscription(ApplicationUser user, Long filterId) throws GenericEntityException {
        return !this.getSubscriptions(user, filterId).isEmpty();
    }

    public boolean hasSubscription(User user, Long filterId) throws GenericEntityException {
        return this.hasSubscription(ApplicationUsers.from((User)user), filterId);
    }

    private GenericValue getSubscription(Long subId) throws GenericEntityException {
        return this.delegator.findById(ENTITY_NAME, subId);
    }

    public GenericValue getSubscription(ApplicationUser user, Long subId) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.delegator.findByAnd(ENTITY_NAME, EasyMap.build((Object)USERKEY, (Object)ApplicationUsers.getKeyFor((ApplicationUser)user), (Object)ID, (Object)subId)));
    }

    public GenericValue getSubscription(User user, Long subId) throws GenericEntityException {
        return this.getSubscription(ApplicationUsers.from((User)user), subId);
    }

    public GenericValue getSubscriptionFromTriggerName(String triggerName) throws GenericEntityException {
        return this.getSubscription(new Long(triggerName.substring(SUBSCRIPTION_PREFIX.length(), triggerName.length())));
    }

    public List<GenericValue> getSubscriptions(ApplicationUser user, Long filterId) throws GenericEntityException {
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        entityExpressions.add(new EntityExpr(USERKEY, EntityOperator.EQUALS, (Object)ApplicationUsers.getKeyFor((ApplicationUser)user)));
        Collection groups = this.groupManager.getGroupNamesForUser(ApplicationUsers.toDirectoryUser((ApplicationUser)user));
        for (String group : groups) {
            entityExpressions.add(new EntityExpr(GROUP, EntityOperator.EQUALS, (Object)group));
        }
        EntityConditionList ownershipCondition = new EntityConditionList(entityExpressions, EntityOperator.OR);
        EntityExpr filterCondition = new EntityExpr(FILTER_ID, EntityOperator.EQUALS, (Object)filterId);
        return this.delegator.findByAnd(ENTITY_NAME, EasyList.build((Object)filterCondition, (Object)ownershipCondition));
    }

    public List<GenericValue> getSubscriptions(User user, Long filterId) throws GenericEntityException {
        return this.getSubscriptions(ApplicationUsers.from((User)user), filterId);
    }

    public Trigger getTriggerFromSubscription(GenericValue subscription) throws SchedulerException {
        return this.getScheduler().getTrigger(SUBSCRIPTION_PREFIX + subscription.getLong(ID), SUBSCRIPTION_IDENTIFIER);
    }

    public void updateSubscription(ApplicationUser user, Long subId, String groupName, Trigger trigger, Boolean emailOnEmpty) throws DataAccessException {
        try {
            this.getScheduler().unscheduleJob(SUBSCRIPTION_PREFIX + subId, SUBSCRIPTION_IDENTIFIER);
            GenericValue subscriptionGV = this.getSubscription(user, subId);
            Map fields = MapBuilder.build((Object)USERKEY, (Object)ApplicationUsers.getKeyFor((ApplicationUser)user), (Object)GROUP, (Object)groupName, (Object)EMAIL_ON_EMPTY, (Object)emailOnEmpty.toString());
            subscriptionGV.setFields(fields);
            subscriptionGV.store();
            if (this.getScheduler().isPaused() || this.getScheduler().isShutdown()) {
                throw new IllegalStateException("The scheduler is paused or shutdown so the subscription was not created.");
            }
            this.populateTriggerFields(trigger, subscriptionGV.getLong(ID));
            this.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void updateSubscription(User user, Long subscriptionId, String groupName, Trigger trigger, Boolean emailOnEmpty) throws DataAccessException {
        this.updateSubscription(ApplicationUsers.from((User)user), subscriptionId, groupName, trigger, emailOnEmpty);
    }

    private void populateTriggerFields(Trigger trigger, Long subscriptionId) throws SchedulerException {
        JobDetail jd = new JobDetail(SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, SendFilterJob.class, false, true, false);
        trigger.setName(SUBSCRIPTION_PREFIX + subscriptionId);
        trigger.setGroup(SUBSCRIPTION_IDENTIFIER);
        trigger.setJobName(SUBSCRIPTION_IDENTIFIER);
        trigger.setJobGroup(SUBSCRIPTION_IDENTIFIER);
        this.getScheduler().addJob(jd, true);
    }

    public List<GenericValue> getAllSubscriptions(Long filterId) {
        return this.delegator.findByAnd(ENTITY_NAME, EasyMap.build((Object)FILTER_ID, (Object)filterId));
    }

    public List<GenericValue> getAllSubscriptions() {
        return this.delegator.findAll(ENTITY_NAME);
    }

    public GenericValue createSubscription(ApplicationUser user, Long filterId, String groupName, Long period, Boolean emailOnEmpty) {
        SimpleTrigger trigger = new SimpleTrigger(SUBSCRIPTION_PREFIX, SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, period * DateUtils.SECOND_MILLIS);
        return this.createSubscription(user, filterId, groupName, (Trigger)trigger, emailOnEmpty);
    }

    public GenericValue createSubscription(User user, Long filterId, String groupName, Long period, Boolean emailOnEmpty) {
        return this.createSubscription(ApplicationUsers.from((User)user), filterId, groupName, period, emailOnEmpty);
    }

    public GenericValue createSubscription(ApplicationUser user, Long filterId, String groupName, Trigger trigger, Boolean emailOnEmpty) {
        if (!TextUtils.stringSet((String)groupName)) {
            groupName = null;
        }
        Map columns = EasyMap.build((Object)FILTER_ID, (Object)filterId, (Object)USERKEY, (Object)ApplicationUsers.getKeyFor((ApplicationUser)user), (Object)GROUP, (Object)groupName, (Object)LAST_RUN, null);
        columns.put(EMAIL_ON_EMPTY, emailOnEmpty.toString());
        GenericValue subscriptionGV = null;
        try {
            if (this.getScheduler().isPaused() || this.getScheduler().isShutdown()) {
                throw new IllegalStateException("The scheduler is paused or shutdown so the subscription was not created.");
            }
            subscriptionGV = EntityUtils.createValue(ENTITY_NAME, columns);
            this.populateTriggerFields(trigger, subscriptionGV.getLong(ID));
            this.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new DataAccessException((Throwable)e);
        }
        return subscriptionGV;
    }

    public GenericValue createSubscription(User user, Long filterId, String groupName, Trigger trigger, Boolean emailOnEmpty) {
        return this.createSubscription(ApplicationUsers.from((User)user), filterId, groupName, trigger, emailOnEmpty);
    }

    public void deleteSubscription(Long subId) throws GenericEntityException, SchedulerException {
        GenericValue subscriptionGV = this.getSubscription(subId);
        if (this.getScheduler().getTrigger(SUBSCRIPTION_PREFIX + subscriptionGV.getLong(ID), SUBSCRIPTION_IDENTIFIER) != null) {
            this.getScheduler().unscheduleJob(SUBSCRIPTION_PREFIX + subscriptionGV.getLong(ID), SUBSCRIPTION_IDENTIFIER);
        } else {
            log.warn((Object)("Unable to find a quartz trigger for the subscription: " + subscriptionGV.getLong(ID) + " removing the subscription anyway."));
        }
        subscriptionGV.remove();
    }

    public void deleteSubscriptionsForUser(@Nonnull ApplicationUser user) throws SchedulerException, GenericEntityException {
        Assertions.notNull((String)"user", (Object)user);
        List subscriptionGvs = this.delegator.findByAnd(ENTITY_NAME, (Map)ImmutableMap.of((Object)USERKEY, (Object)user.getKey()));
        for (GenericValue subscription : subscriptionGvs) {
            this.deleteSubscription(subscription.getLong(ID));
        }
    }

    public void deleteSubscriptionsForUser(User user) throws GenericEntityException, SchedulerException {
        this.deleteSubscriptionsForUser(ApplicationUsers.from((User)user));
    }

    public void runSubscription(GenericValue sub) throws GenericEntityException {
        Timestamp ts = new Timestamp(new Date().getTime());
        sub.set(LAST_RUN, (Object)ts);
        sub.store();
        SubscriptionMailQueueItem item = this.subscriptionMailQueueItemFactory.getSubscriptionMailQueueItem(sub);
        this.mailQueue.addItem((MailQueueItem)item);
    }

    public void runSubscription(ApplicationUser user, Long subId) throws GenericEntityException {
        this.runSubscription(this.getSubscription(user, subId));
    }

    public void runSubscription(User user, Long subId) throws GenericEntityException {
        this.runSubscription(ApplicationUsers.from((User)user), subId);
    }

    public void deleteSubscriptionsForGroup(Group group) throws GenericEntityException, SchedulerException {
        Assertions.notNull((String)GROUP, (Object)group);
        List subscriptionGvs = this.delegator.findByAnd(ENTITY_NAME, (Map)ImmutableMap.of((Object)GROUP, (Object)group.getName()));
        for (GenericValue subscription : subscriptionGvs) {
            this.deleteSubscription(subscription.getLong(ID));
        }
    }

    Scheduler getScheduler() {
        return (Scheduler)ComponentAccessor.getComponentOfType(Scheduler.class);
    }
}

