/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import webwork.action.Action;

public class TextQuerySearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final String name;
    private final SearchInputTransformer searchInputTransformer;

    public TextQuerySearchRenderer(String id, String name, String labelKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, SearchInputTransformer searchInputTransformer) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, id, labelKey);
        this.name = name;
        this.searchInputTransformer = searchInputTransformer;
    }

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.name);
        }
        return TextUtils.htmlEncode((String)value);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        String value = "";
        if (fieldValuesHolder != null) {
            value = (String)fieldValuesHolder.get((Object)this.name);
        }
        return TextUtils.htmlEncode((String)value);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.searchInputTransformer.doRelevantClausesFitFilterForm(user, query, null);
    }
}

