/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.parameters.lucene.sort.IssueSortComparator;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class DocumentSortComparatorSource
extends FieldComparatorSource {
    private final IssueSortComparator sortComparator;

    public DocumentSortComparatorSource(IssueSortComparator sortComparator) {
        this.sortComparator = sortComparator;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new InternalFieldComparator(numHits, fieldname, this.sortComparator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DocumentSortComparatorSource that = (DocumentSortComparatorSource)((Object)o);
        return this.sortComparator != null ? this.sortComparator.equals(that.sortComparator) : that.sortComparator == null;
    }

    public int hashCode() {
        return this.sortComparator != null ? this.sortComparator.hashCode() : 0;
    }

    public final class InternalFieldComparator
    extends FieldComparator {
        private Issue[] values;
        private final int numHits;
        private final String field;
        private IssueSortComparator sortComparator;
        private Issue bottom;
        private IndexReader reader;

        InternalFieldComparator(int numHits, String field, IssueSortComparator sortComparator) {
            int initSize = Math.min(1024, numHits);
            this.values = new Issue[initSize];
            this.field = field;
            this.sortComparator = sortComparator;
            this.numHits = numHits;
        }

        public int compare(int slot1, int slot2) {
            Issue v1 = this.values[slot1];
            Issue v2 = this.values[slot2];
            if (v1 == null) {
                if (v2 == null) {
                    return 0;
                }
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.sortComparator.compare(v1, v2);
        }

        public int compareBottom(int doc) throws IOException {
            Issue v2 = this.sortComparator.getIssueFromDocument(this.reader.document(doc));
            if (this.bottom == null) {
                if (v2 == null) {
                    return 0;
                }
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.sortComparator.compare(this.bottom, v2);
        }

        public void copy(int slot, int doc) throws IOException {
            this.ensureCapacity(slot);
            this.values[slot] = this.sortComparator.getIssueFromDocument(this.reader.document(doc));
        }

        private void ensureCapacity(int slot) {
            if (this.values.length <= slot) {
                int newSize = Math.min(this.numHits, this.values.length * 2);
                if (newSize <= slot) {
                    newSize = slot + 1;
                }
                this.values = Arrays.copyOf(this.values, newSize);
            }
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.reader = reader;
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable<?> value(int slot) {
            return null;
        }
    }
}

