/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIdBatcher;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import org.ofbiz.core.entity.EntityCondition;

public class DefaultIssueBatcherFactory
implements IssueBatcherFactory {
    private static final String BATCH_SIZE_PROPERTY_NAME = "jira.index.background.batch.size";
    private static final int BATCH_SIZE_DEFAULT_VALUE = 1000;
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;
    private final BarrierFactory barrierFactory;
    private final ApplicationProperties applicationProperties;

    public DefaultIssueBatcherFactory(OfBizDelegator delegator, IssueFactory issueFactory, BarrierFactory barrierFactory, ApplicationProperties applicationProperties) {
        this.delegator = delegator;
        this.issueFactory = issueFactory;
        this.barrierFactory = barrierFactory;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public IssuesBatcher getBatcher() {
        return this.getBatcher(null);
    }

    @Override
    public IssuesBatcher getBatcher(EntityCondition condition) {
        return new IssueIdBatcher(this.delegator, this.issueFactory, this.barrierFactory, this.getConfiguredBatchSize(), condition);
    }

    private int getConfiguredBatchSize() {
        return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)BATCH_SIZE_PROPERTY_NAME, (int)1000);
    }
}

