/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class CommentDocument {
    public static Document getDocument(Comment comment, Issue issue) {
        Document doc = new Document();
        String body = comment.getBody();
        if (body != null) {
            ApplicationUser updateAuthor;
            doc.add((Fieldable)new Field("projid", String.valueOf(issue.getProjectObject().getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("issue_id", String.valueOf(issue.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field("id", String.valueOf(comment.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            ApplicationUser author = comment.getAuthorApplicationUser();
            if (author != null) {
                doc.add((Fieldable)new Field("comment_author", author.getKey(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            if ((updateAuthor = comment.getUpdateAuthorApplicationUser()) != null) {
                doc.add((Fieldable)new Field("comment_update_author", updateAuthor.getKey(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            doc.add((Fieldable)new Field("body", body, Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("comment_created", LuceneUtils.dateToString((Date)comment.getCreated()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            Date updated = comment.getUpdated();
            if (updated != null) {
                doc.add((Fieldable)new Field("comment_updated", LuceneUtils.dateToString((Date)updated), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
            FieldIndexerUtil.indexKeywordWithDefault((Document)doc, (String)"level", (String)comment.getGroupLevel(), (String)"-1");
            FieldIndexerUtil.indexKeywordWithDefault((Document)doc, (String)"role_level", (Long)(comment.getRoleLevel() != null ? comment.getRoleLevel().getId() : null), (String)"-1");
            return doc;
        }
        return null;
    }
}

