/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.DefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserKeyService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractColumnLayoutManager
implements ColumnLayoutManager {
    private static final Logger log = Logger.getLogger(AbstractColumnLayoutManager.class);
    protected static final int DEFAULT_CACHE_SIZE = 200;
    private final FieldManager fieldManager;
    protected final OfBizDelegator ofBizDelegator;
    private final ColumnLayout defaultColumnLayout;
    private final UserKeyService userKeyService;
    private final Map<String, CacheableColumnLayout> columnLayoutCache;

    public AbstractColumnLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, UserKeyService userKeyService) {
        this.fieldManager = fieldManager;
        this.ofBizDelegator = ofBizDelegator;
        this.userKeyService = userKeyService;
        this.columnLayoutCache = Collections.synchronizedMap(new LRUMap(200));
        int pos = 0;
        ArrayList<ColumnLayoutItemImpl> cols = new ArrayList<ColumnLayoutItemImpl>();
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuetype"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuekey"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("summary"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("assignee"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("reporter"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("priority"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("status"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("resolution"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("created"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("updated"), pos++));
        cols.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("duedate"), pos++));
        this.defaultColumnLayout = new DefaultColumnLayoutImpl(Collections.unmodifiableList(cols));
    }

    public ColumnLayout getColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            String username = remoteUser == null ? null : remoteUser.getName();
            CacheableColumnLayout cacheableColumnLayout = this.getColumnLayout(username, availableFields);
            List<ColumnLayoutItem> columnLayoutItems = cacheableColumnLayout.columnLayoutItems;
            return new UserColumnLayoutImpl(columnLayoutItems, remoteUser, cacheableColumnLayout.columnConfig);
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            return new DefaultColumnLayoutImpl(this.getColumnLayout(null, (Set<NavigableField>)availableFields).columnLayoutItems);
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout() throws ColumnLayoutStorageException {
        return new DefaultColumnLayoutImpl(this.defaultColumnLayout.getColumnLayoutItems());
    }

    public void refresh() {
        this.columnLayoutCache.clear();
    }

    public EditableDefaultColumnLayout getEditableDefaultColumnLayout() {
        try {
            Set availableFields = this.fieldManager.getAllAvailableNavigableFields();
            return new EditableDefaultColumnLayoutImpl((List)this.getColumnLayout(null, (Set<NavigableField>)availableFields).columnLayoutItems);
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public EditableUserColumnLayout getEditableUserColumnLayout(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
            CacheableColumnLayout columnLayout = this.getColumnLayout(user.getName(), availableFields);
            return new EditableUserColumnLayoutImpl(columnLayout.columnLayoutItems, user, columnLayout.columnConfig);
        }
        catch (FieldException e) {
            throw new DataAccessException("Could not retrieve available fields for user '" + user.getName() + "'.", (Throwable)e);
        }
    }

    public void storeEditableDefaultColumnLayout(EditableDefaultColumnLayout editableDefaultColumnLayout) throws ColumnLayoutStorageException {
        this.storeEditableColumnLayout((ColumnLayout)editableDefaultColumnLayout, null);
        this.columnLayoutCache.clear();
    }

    public void storeEditableUserColumnLayout(EditableUserColumnLayout editableUserColumnLayout) throws ColumnLayoutStorageException {
        String userName = editableUserColumnLayout.getUser().getName();
        String userKey = this.userKeyService.getKeyForUsername(userName);
        if (userKey == null) {
            throw new IllegalArgumentException("The associated user '" + userName + "' does not exist");
        }
        this.storeEditableColumnLayout((ColumnLayout)editableUserColumnLayout, userKey);
        this.columnLayoutCache.remove(userKey);
    }

    public void restoreDefaultColumnLayout() {
        this.restoreColumnLayout(null, null);
        this.columnLayoutCache.clear();
    }

    public void restoreUserColumnLayout(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        String userKey = this.userKeyService.getKeyForUser(user);
        if (userKey == null) {
            log.warn((Object)("Unable to restore column layout for nonexistant user '" + user.getName() + '\''));
            return;
        }
        this.restoreColumnLayout(userKey, user.getName());
        this.columnLayoutCache.remove(userKey);
    }

    boolean hasDefaultColumnLayout(User user) {
        String username = user != null ? user.getName() : null;
        String userKey = this.userKeyService.getKeyForUsername(username);
        return this.fetchColumnLayout(userKey) != null;
    }

    CacheableColumnLayout getColumnLayout(String username, Set<NavigableField> availableFields) {
        String userKey = this.userKeyService.getKeyForUsername(username);
        CacheableColumnLayout columnLayout = this.columnLayoutCache.get(userKey);
        if (columnLayout == null) {
            GenericValue columnLayoutGV = this.getColumnLayoutGv(userKey);
            if (columnLayoutGV == null && (columnLayoutGV = this.fetchColumnLayout(null)) == null) {
                CacheableColumnLayout systemColumnLayout = this.getDefaultColumnLayout(availableFields);
                this.columnLayoutCache.put(userKey, systemColumnLayout);
                return systemColumnLayout;
            }
            try {
                columnLayout = this.getUserColumnLayout(availableFields, columnLayoutGV);
                this.columnLayoutCache.put(userKey, columnLayout);
                return columnLayout;
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Could not retrieve the Column Layout Items.", (Throwable)e);
            }
        }
        return columnLayout;
    }

    abstract List<ColumnLayoutItem> removeUnavailableColumnLayoutItems(List<ColumnLayoutItem> var1, Set<NavigableField> var2);

    abstract List<ColumnLayoutItem> verifyColumnLayoutItems(GenericValue var1, Set<NavigableField> var2) throws GenericEntityException;

    private CacheableColumnLayout getUserColumnLayout(Set<NavigableField> availableFields, GenericValue columnLayoutGV) throws GenericEntityException {
        List<ColumnLayoutItem> columnLayoutItems = this.verifyColumnLayoutItems(columnLayoutGV, availableFields);
        CacheableColumnLayout columnLayout = new CacheableColumnLayout(ColumnLayout.ColumnConfig.USER, columnLayoutItems);
        return columnLayout;
    }

    private CacheableColumnLayout getDefaultColumnLayout(Set<NavigableField> availableFields) {
        List<ColumnLayoutItem> columnLayoutItems = this.removeUnavailableColumnLayoutItems(this.defaultColumnLayout.getColumnLayoutItems(), availableFields);
        return new CacheableColumnLayout(ColumnLayout.ColumnConfig.SYSTEM, columnLayoutItems);
    }

    private GenericValue getColumnLayoutGv(String userKey) {
        GenericValue columnLayoutGV = null;
        if (userKey != null) {
            columnLayoutGV = this.fetchColumnLayout(userKey);
        }
        return columnLayoutGV;
    }

    private synchronized void storeEditableColumnLayout(ColumnLayout columnLayout, String userKey) {
        try {
            GenericValue columnLayoutGV = this.fetchColumnLayout(userKey);
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    protected void storeColumnLayoutItems(GenericValue columnLayoutGV, ColumnLayout columnLayout) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        List columnLayoutItems = columnLayout.getColumnLayoutItems();
        for (int i = 0; i < columnLayoutItems.size(); ++i) {
            ColumnLayoutItem columnLayoutItem = (ColumnLayoutItem)columnLayoutItems.get(i);
            EntityUtils.createValue("ColumnLayoutItem", EasyMap.build((Object)"columnlayout", (Object)columnLayoutGV.getLong("id"), (Object)"fieldidentifier", (Object)columnLayoutItem.getId(), (Object)"horizontalposition", (Object)new Long(i)));
        }
    }

    private synchronized void restoreColumnLayout(String userKey, String username) {
        try {
            GenericValue columnLayoutGV = this.fetchColumnLayout(userKey);
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error removing column layout for username " + username + ".", (Throwable)e);
        }
    }

    private GenericValue fetchColumnLayout(String userKey) {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null)));
    }

    void removeColumnLayoutItems(GenericValue columnLayoutGV) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        columnLayoutGV.remove();
    }

    FieldManager getFieldManager() {
        return this.fieldManager;
    }

    static final class CacheableColumnLayout {
        final ColumnLayout.ColumnConfig columnConfig;
        final List<ColumnLayoutItem> columnLayoutItems;

        CacheableColumnLayout(ColumnLayout.ColumnConfig columnConfig, List<ColumnLayoutItem> columnLayoutItems) {
            this.columnConfig = columnConfig;
            this.columnLayoutItems = columnLayoutItems;
        }
    }
}

